import { IdSet, idSetToList, idSetToSet, listToIdSet, toggleIdSet } from './IdSet';

describe('redux|IdSet', () => {
   it('listToIdSet', () => {
      const ids = ['a', 'b', 'c'];

      expect(listToIdSet(ids)).toEqual({
         a: true,
         b: true,
         c: true,
      });
   });

   it('idSetToList', () => {
      expect(idSetToList({ a: true, b: true, c: false })).toEqual(['a', 'b']);
   });

   it('idSetToSet', () => {
      expect(idSetToSet({ a: true, b: true, c: false })).toEqual(new Set(['a', 'b']));
   });

   it('toggleIdSet', () => {
      const set: IdSet = {
         a: true,
         b: true,
         c: true,
      };

      expect(toggleIdSet(set, 'a')).toEqual({
         b: true,
         c: true,
      });

      expect(toggleIdSet(set, 'w')).toEqual({
         a: true,
         b: true,
         c: true,
         w: true,
      });
   });
});
