export interface IdSet {
   [id: string]: boolean;
}

export const listToIdSet = (ids: string[]) =>
   ids.reduce((acc, id) => {
      acc[id] = true;

      return acc;
   }, {} as IdSet);

export const idSetToList = (set: IdSet): string[] => Object.keys(set).filter(k => set[k]);

export const idSetToSet = (set: IdSet): Set<string> => new Set(idSetToList(set));

export const toggleIdSet = (idSet: IdSet, id: string) => {
   const result = { ...idSet };
   if (result.hasOwnProperty(id)) {
      delete result[id];
   } else {
      result[id] = true;
   }

   return result;
};
