import { createEntityAdapter, createSelector, createSlice, EntityState, PayloadAction } from '@reduxjs/toolkit';
import { TStage } from '../../../proto-typings';

import type { RootState } from '../../../redux';

const name = 'formData';

export type StageFormData = { rawStage: TStage; formId: string };

const stageFormDataAdapter = createEntityAdapter<StageFormData>({
   selectId: data => data.formId,
});

const initialState = {
   stageForms: stageFormDataAdapter.getInitialState(),
};

// endregion

export const formDataSlice = createSlice({
   name,
   initialState,
   reducers: {
      updateStageFormData(state, action: PayloadAction<StageFormData>) {
         stageFormDataAdapter.upsertOne(state.stageForms as EntityState<StageFormData>, action.payload);
      },
   },
});

export const selectStageFormData = createSelector(
   (s: RootState) => s.formData.stageForms,
   (s: RootState, formId: string) => formId,
   (data, formId) => stageFormDataAdapter.getSelectors().selectById(data, formId),
);
