import { ApiErrorItem, ApiServiceName } from '../../../models/api';
import { ApiActionNames } from '../../../services/api/actions/index';
import { NetworkError, NetworkRequest, ServiceErrorData } from './model';

export interface AggregatorAddProps<S extends ApiServiceName, A extends ApiActionNames[S]> {
   service: S;
   action: A;
   requestKey?: string;
   error: ApiErrorItem;
   data?: ServiceErrorData<S>;
   requestData?: object;
   url: string;
}

export interface NetworkAggregatorItem<S extends ApiServiceName = ApiServiceName> {
   error: Omit<NetworkError<S>, 'requestId'>;
   request: Pick<NetworkRequest, 'data' | 'url'>;
}

export class NetworkAggregator {
   add<S extends ApiServiceName, A extends ApiActionNames[S]>({
      error,
      data,
      requestData,
      url,
      service,
      action,
   }: AggregatorAddProps<S, A>): NetworkAggregatorItem<S> {
      const errorData: Omit<NetworkError<S>, 'requestId'> = {
         error: {
            body: error.body,
            ...(data ? { data } : {}),
         },
      };
      const request: Partial<NetworkRequest> = {
         url,
         data: requestData,
         service,
         action: action as ApiActionNames[ApiServiceName],
      };
      return {
         error: errorData,
         request,
      };
   }
}

export const networkAggregator = new NetworkAggregator();
