import { EntityState } from '@reduxjs/toolkit';
import { ApiServiceName, NetworkYpErrorData } from '../../../models/api';
import { ApiActionNames } from '../../../services/api/actions';

export const networkReduxNamespace = 'network';

export interface NetworkErrorDataByService {
   [ApiServiceName.YP]: NetworkYpErrorData;
}

export type ServiceErrorData<S> = S extends keyof NetworkErrorDataByService ? NetworkErrorDataByService[S] : string;

export interface NetworkError<S extends ApiServiceName = ApiServiceName> {
   requestId: string;
   requestKey?: string;
   error: {
      body: string;
      data?: ServiceErrorData<S>;
   };
   message?: string;
}

export type NetworkErrorsStore = {
   data: EntityState<NetworkError>;
};

export enum RequestState {
   PENDING = 'pending',
   OK = 'ok',
   ERROR = 'error',
}

export interface NetworkRequest {
   requestId: string;
   state: RequestState;
   timestamps: {
      [state in RequestState]?: number;
   };
   lastOkTimestamp?: number;
   requestKey?: string;
   url?: string;
   data?: object;
   service?: ApiServiceName;
   action?: ApiActionNames[ApiServiceName];
}

export type NetworkRequestsStore = {
   data: EntityState<NetworkRequest>;
};

export interface NetworkItem {
   error: NetworkError;
   request: NetworkRequest;
}
