import { createSelector, createSlice } from '@reduxjs/toolkit';
import { getSetDifference } from '@yandex-infracloud-ui/libs';

import type { RootState } from '../../..';
import { selectYp, YpApprovalPolicyStore, ypReduxNamespace } from '../model';
import { ypRequestAsyncThunk } from '../ypRequestAsyncThunk';
import { loadReleasesData } from './releaseData';
import { getNestedSliceName, getNestedSliceSelector } from '../../../utils/nestedSlice';

const name = 'approvalPolicy';
const namespace = getNestedSliceName(ypReduxNamespace, name);

const initialState: YpApprovalPolicyStore = {};

export const fetchApprovalPolicy = ypRequestAsyncThunk(`${namespace}/fetch`, 'fetchApprovalPolicy');
export const fetchApprovalPolicies = ypRequestAsyncThunk(`${namespace}/fetchMany`, 'fetchApprovalPolicies');
export const deleteApprovalPolicy = ypRequestAsyncThunk(`${namespace}/remove`, 'deleteApprovalPolicy');
export const createApprovalPolicy = ypRequestAsyncThunk(`${namespace}/create`, 'createApprovalPolicy');
export const updateApprovalPolicy = ypRequestAsyncThunk(`${namespace}/update`, 'updateApprovalPolicy');

/*
Все id для ApprovalPolicy совпадают с id соответствующих Stage
TODO: поменять на entity adapter
*/

export const approvalPolicySlice = createSlice({
   name: namespace,
   initialState,
   reducers: {},
   extraReducers: builder => {
      builder.addCase(fetchApprovalPolicy.fulfilled, (state, action) => {
         const { response, params } = action.payload;
         const [stageId] = params;
         state[stageId] = response ?? null;
      });

      builder.addCase(fetchApprovalPolicies.fulfilled, (state, action) => {
         const { response, params } = action.payload;
         const [stageIds] = params;
         for (let i = 0; i < stageIds.length; i += 1) {
            state[stageIds[i]] = response[i] ?? null;
         }
      });

      builder.addCase(deleteApprovalPolicy.fulfilled, (state, action) => {
         const [stageId] = action.payload.params;
         if (state.hasOwnProperty(stageId)) {
            delete state[stageId];
         }
      });

      builder.addCase(loadReleasesData.fulfilled, (state, action) => {
         const {
            response: { approval },
         } = action.payload;
         const { values, ids } = approval.policies;
         const exist = new Set<string>();
         for (const policy of values) {
            const id = policy.meta?.id;
            if (id) {
               exist.add(id);
               state[id] = policy;
            }
         }
         const { removed } = getSetDifference(ids, exist);
         for (const id of removed.values()) {
            state[id] = null;
         }
      });
   },
});

export const selectApprovalPolicyStore = getNestedSliceSelector({
   name,
   initialState,
   parentSelector: selectYp,
});

export const selectApprovalPolicy = createSelector(
   selectApprovalPolicyStore,
   (s: RootState, stageId: string) => stageId,
   (policices, stageId) => policices[stageId],
);

export const selectApprovalPolicies = createSelector(
   selectApprovalPolicyStore,
   (s: RootState, stageIds: string[]) => stageIds,
   (policices, stageIds) =>
      stageIds.reduce((obj, stageId) => {
         obj[stageId] = policices[stageId];
         return obj;
      }, {} as YpApprovalPolicyStore),
);
