import { createSlice } from '@reduxjs/toolkit';
import { UsedYpObjectTypes } from '../../../../models/api';

import { selectYp, YpAvailableObjectsStore, ypReduxNamespace } from '../model';

import { ypRequestAsyncThunk } from '../ypRequestAsyncThunk';
import { getNestedSliceName, getNestedSliceSelector } from '../../../utils';

const name = 'availableObjects';
const namespace = getNestedSliceName(ypReduxNamespace, name);

const initialState = {} as YpAvailableObjectsStore;

type ResetByObjectType = Partial<Record<UsedYpObjectTypes, boolean>>;

export const fetchAvailableObjects = ypRequestAsyncThunk(
   `${namespace}/fetch`,
   'getAvailableIds',
   {} as ResetByObjectType,
);

export const availableObjectsSlice = createSlice({
   name: namespace,
   initialState,
   reducers: {},
   extraReducers: builder => {
      builder.addCase(fetchAvailableObjects.fulfilled, (state, action) => {
         const { params, response, meta } = action.payload;
         const { requests } = params[0];
         for (let i = 0; i < requests.length; i += 1) {
            const ids = response[i] ?? [];
            const { objectType, login } = requests[i];
            const reset = meta[objectType] ?? false;

            if (reset) {
               state[objectType] = {};
            }
            for (const id of ids) {
               if (!(objectType in state)) {
                  state[objectType] = {};
               }
               if (!(id in state[objectType])) {
                  state[objectType][id] = {};
               }
               state[objectType][id][login ?? ''] = true;
            }
         }
      });
   },
});

export const selectAvailableObjects = getNestedSliceSelector({
   name,
   initialState,
   parentSelector: selectYp,
});
