import { createSlice, createSelector } from '@reduxjs/toolkit';

import { ypReduxNamespace, YPNodeInfoStore, selectYp } from '../model';
import { ypRequestAsyncThunk } from '../ypRequestAsyncThunk';

import { TNode, TPod, TResource } from '../../../../proto-typings';
import { getNestedSliceName, getNestedSliceSelector } from '../../../utils/nestedSlice';

const name = 'nodeInfo';
const namespace = getNestedSliceName(ypReduxNamespace, name);

const initialState = {} as YPNodeInfoStore;

export const getNodeInfo = ypRequestAsyncThunk(`${namespace}/getNode`, 'getYPNode');

export const getNodeResources = ypRequestAsyncThunk(`${namespace}/getNodeResources`, 'getNodeResources');

export const getNodePods = ypRequestAsyncThunk(`${namespace}/getNodePods`, 'getNodePods');

export const nodeInfoSlice = createSlice({
   name: namespace,
   initialState,
   reducers: {},
   extraReducers: builder => {
      builder.addCase(getNodeInfo.fulfilled, (state, action) => {
         const { response: nodeInfo } = action.payload;

         if (nodeInfo) {
            state.node = nodeInfo as TNode;
         }
      });

      builder.addCase(getNodeResources.fulfilled, (state, action) => {
         const { response: resources } = action.payload;

         state.resources = resources as TResource[];
      });

      builder.addCase(getNodePods.fulfilled, (state, action) => {
         const { response: pods } = action.payload;

         state.pods = pods as TPod[];
      });
   },
});

export const selectNodeInfoStore = getNestedSliceSelector({
   name,
   initialState,
   parentSelector: selectYp,
});

export const selectNode = createSelector(selectNodeInfoStore, store => store.node);
export const selectNodeResources = createSelector(selectNodeInfoStore, store => store.resources);
export const selectNodePods = createSelector(selectNodeInfoStore, store => store.pods);
