import { createSlice, createSelector } from '@reduxjs/toolkit';

import { ypReduxNamespace, YPNodesInfoStore, selectYp } from '../model';
import { ypRequestAsyncThunk } from '../ypRequestAsyncThunk';

import { TNode, TNodeSegment } from '../../../../proto-typings';
import { getNestedSliceName, getNestedSliceSelector } from '../../../utils/nestedSlice';

const name = 'nodes';
const namespace = getNestedSliceName(ypReduxNamespace, name);

const initialState = { nodes: [], segments: [] } as YPNodesInfoStore;

export const getNodes = ypRequestAsyncThunk(`${namespace}/getNodes`, 'getYPNodes', { reset: false });
export const getNodesSegments = ypRequestAsyncThunk(`${namespace}/getNodesSegments`, 'getYPNodesSegments');

export const nodesSlice = createSlice({
   name: namespace,
   initialState,
   reducers: {},
   extraReducers: builder => {
      builder.addCase(getNodes.fulfilled, (state, action) => {
         const {
            response: { items },
            meta: { reset },
         } = action.payload;

         if (items) {
            if (reset) {
               state.nodes = items as TNode[];
            } else {
               state.nodes = state.nodes.concat(items as TNode[]);
            }
         }
      });

      builder.addCase(getNodesSegments.fulfilled, (state, action) => {
         const { response: values } = action.payload;

         if (values) {
            state.segments = values as TNodeSegment[];
         }
      });
   },
});

export const selectNodesStore = getNestedSliceSelector({
   name,
   initialState,
   parentSelector: selectYp,
});

export const selectNodes = createSelector(selectNodesStore, store => store.nodes);
export const selectNodesSegments = createSelector(selectNodesStore, store => store.segments);
