import { createSlice, createSelector } from '@reduxjs/toolkit';

import { ypReduxNamespace, YPPodSetInfoStore, selectYp } from '../model';
import { ypRequestAsyncThunk } from '../ypRequestAsyncThunk';

import { TPodSet } from '../../../../proto-typings';
import { getNestedSliceName, getNestedSliceSelector } from '../../../utils/nestedSlice';

const name = 'podSetInfo';
const namespace = getNestedSliceName(ypReduxNamespace, name);

const initialState = {} as YPPodSetInfoStore;

export const getPodSetInfo = ypRequestAsyncThunk(`${namespace}/getNode`, 'getPodSet');

// export const getNodePods = ypRequestAsyncThunk(`${namespace}/getNodePods`, 'getNodePods');

export const podSetInfoSlice = createSlice({
   name: namespace,
   initialState,
   reducers: {},
   extraReducers: builder => {
      builder.addCase(getPodSetInfo.fulfilled, (state, action) => {
         const { response: podSet } = action.payload;

         if (podSet) {
            state.podSet = podSet as TPodSet;
         }
      });
      // builder.addCase(getNodePods.fulfilled, (state, action) => {
      //    const { response: pods } = action.payload;

      //    state.pods = pods as TPod[];
      // });
   },
});

export const selectPodSetInfo = getNestedSliceSelector({
   name,
   initialState,
   parentSelector: selectYp,
});

export const selectPodSet = createSelector(selectPodSetInfo, info => info.podSet);
