import { createSelector, createSlice } from '@reduxjs/toolkit';

import { QuotaKeyParams, QuotaMetric, quotaConverter } from '../../../../models/ui/quota';
import { TResourceTotals } from '../../../../proto-typings';
import type { RootState } from '../../../store';

import { selectYp, YpQuotaStore, ypReduxNamespace } from '../model';
import { ypRequestAsyncThunk } from '../ypRequestAsyncThunk';
import { getNestedSliceName, getNestedSliceSelector } from '../../../utils/nestedSlice';

const name = 'quota';
const namespace = getNestedSliceName(ypReduxNamespace, name);

const initialState: YpQuotaStore = {
   flatStore: {},
};

export const getQuota = ypRequestAsyncThunk(`${namespace}/get`, 'getAccount', { reset: false });

export const quotaSlice = createSlice({
   name: namespace,
   initialState,
   reducers: {},
   extraReducers: builder => {
      builder.addCase(getQuota.fulfilled, (state, action) => {
         const { response, params, meta } = action.payload;
         const [abc, ypLocation] = params;
         const { spec, status } = response;
         const newFlatStore: Record<string, number> = {};
         if (spec) {
            const { resource_limits } = spec;
            if (resource_limits) {
               const storePart = quotaConverter.getUIModel({
                  location: ypLocation,
                  abc,
                  metric: QuotaMetric.Total,
                  resourcesData: resource_limits as Partial<TResourceTotals>,
               });
               for (const [key, value] of Object.entries(storePart)) {
                  newFlatStore[key] = value;
               }
            }
         }
         if (status) {
            const { resource_usage } = status;
            if (resource_usage) {
               const storePart = quotaConverter.getUIModel({
                  location: ypLocation,
                  abc,
                  metric: QuotaMetric.Usage,
                  resourcesData: resource_usage as Partial<TResourceTotals>,
               });
               for (const [key, value] of Object.entries(storePart)) {
                  newFlatStore[key] = value;
               }
            }
         }

         if (Object.keys(newFlatStore).length > 0) {
            state.flatStore = meta.reset ? newFlatStore : { ...state.flatStore, ...newFlatStore };
         }
      });
   },
});

export const selectQuotaStore = getNestedSliceSelector({
   name,
   initialState,
   parentSelector: selectYp,
});

export const selectQuotaTree = createSelector(
   selectQuotaStore,
   (state: RootState, order: [keyof QuotaKeyParams, ...(keyof QuotaKeyParams)[]]) => order,
   (store, order) => quotaConverter.getTree(store.flatStore, order),
);
