import { createSlice, createSelector } from '@reduxjs/toolkit';
import { isEqual } from '@yandex-infracloud-ui/libs';

import { YpLocation } from '../../../../models/api';
import { EObjectType } from '../../../../proto-typings';
import type { RootState } from '../../../store';

import { selectYp, ypReduxNamespace, YpReplicaSetsStore } from '../model';
import { ypRequestAsyncThunk } from '../ypRequestAsyncThunk';
import { getNestedSliceName, getNestedSliceSelector } from '../../../utils/nestedSlice';

const name = 'replicaSets';
const namespace = getNestedSliceName(ypReduxNamespace, name);

const initialState = {} as YpReplicaSetsStore;

export const getReplicaSet = ypRequestAsyncThunk(`${namespace}/get`, 'getReplicaSet');

export const replicaSetsSlice = createSlice({
   name: namespace,
   initialState,
   reducers: {},
   extraReducers: builder => {
      builder.addCase(getReplicaSet.fulfilled, (state, action) => {
         const { params, response: replicaSet } = action.payload;
         const { type, location, id } = params[0];
         const ypLocation = type === EObjectType.OT_MULTI_CLUSTER_REPLICA_SET ? YpLocation.XDC : location!;

         const previousReplicaSet = state[ypLocation] ? state[ypLocation][id] : undefined;
         if (isEqual(replicaSet, previousReplicaSet)) {
            return;
         }

         if (!state.hasOwnProperty(ypLocation)) {
            state[ypLocation] = {};
         }
         state[ypLocation][id] = replicaSet;
      });
   },
});

const selectReplicaSetStore = getNestedSliceSelector({
   name,
   initialState,
   parentSelector: selectYp,
});

type ReplicaSetKey = { location: string; id: string };
export const selectReplicaSets = createSelector(
   (s: RootState, keys: ReplicaSetKey[]) => keys,
   selectReplicaSetStore,
   (keys, replicaSetStore) => keys.map(({ location, id }) => replicaSetStore[location]?.[id]),
);

export const selectReplicaSet = createSelector(
   (s: RootState, location: YpLocation) => location,
   (s: RootState, _, id: string) => id,
   selectReplicaSetStore,
   (location, id, replicaSetStore) => replicaSetStore[location]?.[id],
);
