import { createSlice } from '@reduxjs/toolkit';

import { selectYp, ypReduxNamespace, YPStageNamesByProjectStore } from '../model';
import { deleteStage, fetchStages, getStages } from './stages';
import { getNestedSliceName, getNestedSliceSelector } from '../../../utils/nestedSlice';

const name = 'stageNamesByProject';
const namespace = getNestedSliceName(ypReduxNamespace, name);

const initialState: YPStageNamesByProjectStore = {};

export const stageNamesByProjectSlice = createSlice({
   name: namespace,
   initialState,
   reducers: {},
   extraReducers: builder => {
      builder.addCase(fetchStages.fulfilled, (state, action) => {
         const {
            response: { values = [] },
            params,
            meta,
         } = action.payload;
         const { project } = params[0];
         const { reset } = meta;
         if (reset) {
            state = {};
         }

         for (const item of values) {
            const stageId = item.meta!.id!;
            const projectId = project ?? item?.meta?.project_id;

            if (projectId) {
               if (!(projectId in state)) {
                  state[projectId] = {};
               }
               state[projectId][stageId] = true;
            }
         }

         return state;
      });

      builder.addCase(getStages.fulfilled, (state, action) => {
         const { params, response: values, meta } = action.payload;
         const { objectIds } = params[0];
         const { projectIds } = meta;
         for (let i = 0; i < objectIds.length; i += 1) {
            const stageId = objectIds[i];
            const item = values[i];
            const projectId = projectIds[i] ?? item?.meta?.project_id;

            if (projectId) {
               if (!(projectId in state)) {
                  state[projectId] = {};
               }

               state[projectId][stageId] = true;
            }
         }
      });

      builder.addCase(deleteStage.fulfilled, (state, action) => {
         const { params } = action.payload;
         const stageId = params[0];

         for (const projectId in state) {
            if (state.hasOwnProperty(projectId)) {
               const projectStages = state[projectId];

               if (stageId in projectStages) {
                  delete projectStages[stageId];
               }
            }
         }
      });
   },
});

export const selectStageNamesByProject = getNestedSliceSelector({
   name,
   initialState,
   parentSelector: selectYp,
});
