import { createSlice, PayloadAction, createSelector } from '@reduxjs/toolkit';
import { selectYp, YPMultiClusterReplicaSetsStore, ypReduxNamespace } from '../model';
import { ypRequestAsyncThunk } from '../ypRequestAsyncThunk';
import { GetApiThunkOutput } from '../../../utils';
import type { RootState } from '../../../store';
import { TMultiClusterReplicaSet } from '../../../../proto-typings';
import { getNestedSliceName, getNestedSliceSelector } from '../../../utils/nestedSlice';

const name = 'ypMulticlusterReplicaSets';
const namespace = getNestedSliceName(ypReduxNamespace, name);

const initialState = {} as YPMultiClusterReplicaSetsStore;

export const getMulticlusterReplicaSets = ypRequestAsyncThunk(
   `${namespace}/getMulticlusterReplicaSets`,
   'getMulticlusterReplicaSets',
   {
      reset: false,
   },
);
export const getMulticlusterReplicaSet = ypRequestAsyncThunk(
   `${namespace}/getMulticlusterReplicaSet`,
   'getMulticlusterReplicaSet',
);

export const ypMulticlusterClusterReplicaSetSlice = createSlice({
   name: namespace,
   initialState,
   reducers: {},
   extraReducers: builder => {
      builder.addCase(
         getMulticlusterReplicaSets.fulfilled,
         (state, action: PayloadAction<GetApiThunkOutput<typeof getMulticlusterReplicaSets>>) => {
            const {
               payload: { response },
            } = action;

            const replicaSets = response.values as TMultiClusterReplicaSet[];

            replicaSets.forEach(replicaSet => {
               const id = replicaSet.meta?.id;

               if (id) {
                  state[id] = replicaSet;
               }
            });
         },
      );

      builder.addCase(
         getMulticlusterReplicaSet.fulfilled,
         (state, action: PayloadAction<GetApiThunkOutput<typeof getMulticlusterReplicaSet>>) => {
            const {
               payload: { params, response },
            } = action;

            const [id] = params;
            if (response) {
               state[id] = response as TMultiClusterReplicaSet;
            }
         },
      );
   },
});

const selectMCRSStore = getNestedSliceSelector({
   name,
   initialState,
   parentSelector: selectYp,
});

export const selectYpMulticlusterReplicaSets = (state: RootState, ids?: string[]) => {
   if (!ids) {
      return undefined;
   }
   const replicaSets = selectMCRSStore(state);

   return ids.map(id => replicaSets[id]).filter(Boolean);
};

export const selectYpMulticlusterReplicaSet = createSelector(
   selectMCRSStore,
   (_: RootState, replicaSetId: string) => replicaSetId,
   (store, id) => store[id],
);
