import { createSlice } from '@reduxjs/toolkit';
import { getNestedSliceData } from '../../utils';
import { ypReduxNamespace } from './model';
import {
   approvalPolicySlice,
   availableObjectsSlice,
   continuationTokensSlice,
   draftsSlice,
   historySlice,
   permissionsSlice,
   podsSlice,
   projectsSlice,
   releasesSlice,
   replicaSetsSlice,
   stageNamesByProjectSlice,
   stagesSlice,
   nodeInfoSlice,
   quotaSlice,
   podInfoSlice,
   nodesSlice,
   releaseRulesSlice,
   ypClusterSlice,
   releaseDataSlice,
   podSetInfoSlice,
   ypQuotaSlice,
   ypClusterReplicaSetSlice,
   ypFiltersSlice,
   ypMulticlusterClusterReplicaSetSlice,
   deployTicketsSlice,
} from './slices';

// WARNING!!! Имя ключа объекта должно совпадать с суффиксом в namespace, который мы пишем в слайсе
// Например, для ypReplicaSets в слайсе мы задаем значение namespace `${ypReduxNamespace}/ypReplicaSets`
// По всем вопросам, почему так, обращаться к @nikolaichev
const { initialState, setupMatcher } = getNestedSliceData({
   prefix: ypReduxNamespace,
   slices: {
      approvalPolicy: approvalPolicySlice,
      availableObjects: availableObjectsSlice,
      continuationTokens: continuationTokensSlice,
      deployTickets: deployTicketsSlice,
      drafts: draftsSlice,
      history: historySlice,
      permissions: permissionsSlice,
      pods: podsSlice,
      projects: projectsSlice,
      releases: releasesSlice,
      releaseData: releaseDataSlice,
      releaseRules: releaseRulesSlice,
      replicaSets: replicaSetsSlice,
      stages: stagesSlice,
      stageNamesByProject: stageNamesByProjectSlice,
      nodeInfo: nodeInfoSlice,
      quota: quotaSlice,
      podInfo: podInfoSlice,
      nodes: nodesSlice,
      ypCluster: ypClusterSlice,
      podSetInfo: podSetInfoSlice,
      ypQuota: ypQuotaSlice,
      ypReplicaSets: ypClusterReplicaSetSlice,
      ypFilters: ypFiltersSlice,
      ypMulticlusterReplicaSets: ypMulticlusterClusterReplicaSetSlice,
   },
});

export type YpState = typeof initialState;

export const ypSlice = createSlice({
   name: ypReduxNamespace,
   initialState,
   reducers: {},
   extraReducers: builder => {
      setupMatcher(builder);
   },
});
