import { Action, configureStore as toolkitConfigureStore, getDefaultMiddleware, ThunkAction } from '@reduxjs/toolkit';
import { reducer as form } from 'redux-form';
import { createLogger } from 'redux-logger';

import { PropType } from '../models';

// подробнее про импорты смотрите ./README.md

// импортируем только часть, нужную для редакса
import { formStatesSlice, nodeStateSlice } from '../components/forms/parts/FormLocalState';

// импортируем только часть, нужную для редакса, пока modules/secrets не стал независимым пакетом
import { secretsSlice } from '../modules/secrets/slice';

import { API } from '../old-code/services/api';
import Notifications from '../old-code/services/Notifications';

import abc from '../old-code/store/reducers/abc';
import awacs from '../old-code/store/reducers/awacs';
import balancers from '../old-code/store/reducers/balancers';
import clusters from '../old-code/store/reducers/clusters';
import deploy from '../old-code/store/reducers/deploy';
import deployAuth from '../old-code/store/reducers/deployAuth';
import sandbox from '../old-code/store/reducers/sandbox';
import staff from '../old-code/store/reducers/staff';
import user from '../old-code/store/reducers/user';
import yasm from '../old-code/store/reducers/yasm';
// noinspection ES6PreferShortImport
import { Config } from '../services/Config';
import { startrekSlice, ypSlice, xraySlice, formDataSlice, infraDoctorSlice } from './slices';
import { networkSlice } from './slices/network/network';

interface ThunkExtraArguments {
   api: API;
   notifications: Notifications;
}

export const configureStore = (extraArgument: ThunkExtraArguments) => {
   // customize default toolkit middleware
   const defaultMiddleware = getDefaultMiddleware({
      thunk: { extraArgument },
      serializableCheck: false, // TODO разобраться с местами, где падает
      immutableCheck: false,
   });

   const middleware = [...defaultMiddleware];

   // logger middleware
   const dev = process.env.NODE_ENV !== 'production';
   const loggerConfig = Config.getReduxLoggerConfig();
   if (dev && loggerConfig.enabled) {
      middleware.push(createLogger(loggerConfig));
   }

   return toolkitConfigureStore({
      reducer: {
         user,
         clusters,
         staff,
         abc,
         sandbox,
         awacs,
         yp: ypSlice.reducer,
         xray: xraySlice.reducer,
         formData: formDataSlice.reducer,
         infraDoctor: infraDoctorSlice.reducer,
         deploy,
         deployAuth,
         balancers,
         yasm,

         form, // redux-form

         formStates: formStatesSlice.reducer,
         nodeStates: nodeStateSlice.reducer,
         startrek: startrekSlice.reducer,
         network: networkSlice.reducer,
         secrets: secretsSlice.reducer,
      },
      middleware,
   });
};

type Store = ReturnType<typeof configureStore>;
export type RootState = ReturnType<PropType<Store, 'getState'>>;

export type AppThunk = ThunkAction<void, RootState, unknown, Action<string>>;
