/*
Сбор ошибок для Error Booster (https://error.yandex-team.ru)
Инициализируется один раз в точке входа приложения (index.tsx)
*/

import Stats from '@yandex-infracloud-ui/yasm-browser-agent';

import '@yandex-int/error-counter/dist/interfaceWithoutRum';
import '@yandex-int/error-counter/dist/implementation';
import '@yandex-int/error-counter/dist/filters';
import '@yandex-int/error-counter/dist/sendWithoutRum';
import '@yandex-int/error-counter/dist/logError';
import '@yandex-int/error-counter/dist/logAjaxError';

import { Config } from './Config';

export class Ebooster {
   constructor(private config: Config) {}

   public init() {
      if (this.config.isLocalhost) {
         return;
      }

      Ya.Rum.initErrors({
         clck: this.config.clck,
         project: 'deploy',
         env: this.config.getLogEnv(),
         platform: 'desktop',
         version: this.config.version,
         debug: this.config.isLocalhost,
         filters: {
            message: {
               '0': /Unhandled rejection: Network Error/,
               '1': /Error: Network Error/,
               '2': /_mouseMoveEventMerger is not a function/, // internal monaco error
            },
         },
         onError(error: Ya.Rum.NormalizedError) {
            // external - ошибки попавшие под фильтр, такие считать не нужно
            if (error.type !== 'external') {
               Stats.incrementCounter(`errors.client.booster`, 'mmmm');
            }
         },
         unhandledRejection: true,
         additional: {
            login: this.config.user.login,
         },
      });
   }

   public sendError(error: Error) {
      Ya.Rum.logError({ type: 'error-boundary' }, error);
   }
}
