/*
Логи yasm
Инициализируется один раз в точке входа приложения (index.tsx)
*/
import Stats from '@yandex-infracloud-ui/yasm-browser-agent';

import { Config } from './Config';

export class Yasm {
   constructor(private config: Config) {}

   public init() {
      Stats.removeTag('browser');
      Stats.setTag('ctype', this.config.getLogEnv());
      Stats.config({
         itype: 'deployui',
         path: this.config.yasmPush,
         debug: this.config.isLocalhost, // metrics not send if debug=true
         ajax: false,
         exceptions: false,
         memoryUsage: false,
         network: false,
         tabs: true,
         visibility: false,
      }).install();
   }
}
