/*
logError обеспечивает логгирование ошибок и неработоспособности апи в головане (yasm)
requestWithLogError обертка над запросом для подключения логирования
*/

import Stats from '@yandex-infracloud-ui/yasm-browser-agent';
import { Observable } from 'rxjs';
import { catchError } from 'rxjs/operators';

import { ApiErrorItem, ApiServiceName } from '../../models/api';
import { ApiActionNames } from './actions';

interface LogErrorProps {
   service: ApiServiceName;
   action: ApiActionNames[ApiServiceName];
   data: any;
   query: string;
   status: number | undefined;
   additional?: object;
}

export function logError({ service, action, status, data, query, additional: customAdditional }: LogErrorProps) {
   if (Number(status) >= 500 || status === undefined) {
      let additional = undefined;
      Stats.incrementCounter(`errors.network.${service}`, 'mmmm');
      Stats.incrementCounter(`errors.network.${service}.${action}`, 'mmmm');

      if (Number(status) >= 500) {
         Stats.incrementCounter(`errors.network.${service}.5xx`, 'mmmm');
         Stats.incrementCounter(`errors.network.${service}.${action}.5xx`, 'mmmm');

         additional = {
            status,
            data,
            query,
         };
      }

      if (customAdditional) {
         additional = {
            ...additional,
            ...customAdditional,
         };
      }

      Ya.Rum.logError({
         message: `API Error: ${service}`,
         type: 'network',
         level: Ya.Rum.ERROR_LEVEL.ERROR,
         source: service,
         sourceMethod: action,
         additional,
      });
   }
}

export function requestWithLogError<R>(request: Observable<R>): Observable<R> {
   return request.pipe(
      catchError(error => {
         const { requestMetaData } = error;
         if (!requestMetaData) {
            throw error;
         }
         const { service, action, data, headers } = requestMetaData;
         logError({
            status: (error as ApiErrorItem).resp?.status,
            service,
            action,
            data,
            query: '',
            additional: {
               requestId: headers?.['X-YT-Request-Id'],
            },
         });
         throw error;
      }),
   );
}
