import { HttpMethod } from '@yandex-infracloud-ui/libs';
import { ApiAction } from '../../../models/api';

// config => `/api/v4/services/${config.serviceId}/?fields=${config.fields || 'id,name,slug'}`
const Service: ApiAction = {
   method: HttpMethod.GET,
   path: config => `/api/v4/services/${config.serviceId}/`,
   credentials: true,
};

const ListTvmApps: ApiAction = {
   method: HttpMethod.GET,
   path: '/api/v4/resources/consumers/',
   credentials: true,
};

export const actions = {
   Service,
   ListTvmApps,
};
