import { HttpMethod } from '@yandex-infracloud-ui/libs';
import { ApiAction, AwacsApiActions } from '../../../models/api';

const Groups: ApiAction = {
   method: HttpMethod.GET,
   path: '/api/_helpers/abc/multicomplete/',
   credentials: true,
};

const ListNamespaceSummaries: ApiAction = {
   method: HttpMethod.POST,
   path: '/api/ListNamespaceSummaries/',
   credentials: true,
};

const BalancersNamespacesListNonQuickStart: ApiAction = {
   method: HttpMethod.POST,
   path: '/api/ListBackends/',
   credentials: true,
};

const ListBackends: ApiAction = {
   method: HttpMethod.POST,
   path: '/api/ListBackends/',
   credentials: true,
};

const ListBalancers: ApiAction = {
   method: HttpMethod.POST,
   path: '/api/ListBalancers/',
   credentials: true,
};

const ListUpstreams: ApiAction = {
   method: HttpMethod.POST,
   path: '/api/ListUpstreams/',
   credentials: true,
};

const ListDnsRecords: ApiAction = {
   method: HttpMethod.POST,
   path: '/api/ListDnsRecords/',
   credentials: true,
};

const ListCertificates: ApiAction = {
   method: HttpMethod.POST,
   path: '/api/ListCertificates/',
   credentials: true,
};

const ListCertificateRenewals: ApiAction = {
   method: HttpMethod.POST,
   path: '/api/ListCertificateRenewals/',
   credentials: true,
};

const CreateBalancer: ApiAction = {
   method: HttpMethod.POST,
   path: '/api/CreateNamespace/',
   credentials: true,
};

const GetBalancersAspectSets: ApiAction = {
   method: HttpMethod.POST,
   path: '/api/ListBalancerAspectsSets/',
   credentials: true,
};

const GetNamespace: ApiAction = {
   method: HttpMethod.POST,
   path: '/api/GetNamespace/',
   credentials: true,
};

const GetQuickStartBalancersUnion: ApiAction = {
   method: HttpMethod.GET,
   path: '/api/GetQuickStartBalancersUnion/',
   credentials: true,
};

const UpdateQuickStartBalancersUnion: ApiAction = {
   method: HttpMethod.POST,
   path: '/api/UpdateQuickStartBalancersUnion/',
   credentials: true,
};

const GetL3Balancers: ApiAction = {
   method: HttpMethod.POST,
   path: '/api/ListL3Balancers/',
   credentials: true,
};

const GetNamespaceAspectsSet: ApiAction = {
   method: HttpMethod.POST,
   path: '/api/GetNamespaceAspectsSet/',
   credentials: true,
};

export const actions = {
   [AwacsApiActions.Groups]: Groups,
   [AwacsApiActions.ListNamespaceSummaries]: ListNamespaceSummaries,
   [AwacsApiActions.BalancersNamespacesListNonQuickStart]: BalancersNamespacesListNonQuickStart,
   [AwacsApiActions.ListBackends]: ListBackends,
   [AwacsApiActions.ListBalancers]: ListBalancers,
   [AwacsApiActions.ListUpstreams]: ListUpstreams,
   [AwacsApiActions.ListDnsRecords]: ListDnsRecords,
   [AwacsApiActions.ListCertificates]: ListCertificates,
   [AwacsApiActions.ListCertificateRenewals]: ListCertificateRenewals,
   [AwacsApiActions.CreateBalancer]: CreateBalancer,
   [AwacsApiActions.GetBalancersAspectSets]: GetBalancersAspectSets,
   [AwacsApiActions.GetNamespace]: GetNamespace,
   [AwacsApiActions.GetQuickStartBalancersUnion]: GetQuickStartBalancersUnion,
   [AwacsApiActions.UpdateQuickStartBalancersUnion]: UpdateQuickStartBalancersUnion,
   [AwacsApiActions.GetL3Balancers]: GetL3Balancers,
   [AwacsApiActions.GetNamespaceAspectsSet]: GetNamespaceAspectsSet,
};
