import { HttpMethod } from '@yandex-infracloud-ui/libs';
import { ApiAction } from '../../../models/api';

const Secrets: ApiAction = {
   method: HttpMethod.GET,
   path: '/api/yav/ListSecrets/',
   credentials: true,
};

const SecretVersions: ApiAction = {
   method: HttpMethod.GET,
   path: '/api/yav/ListSecretVersions/',
   credentials: true,
};

const DelegationToken: ApiAction = {
   method: HttpMethod.GET,
   path: '/api/yav/CreateDelegationToken/',
   credentials: true,
};

const SearchLogEntries: ApiAction = {
   method: HttpMethod.POST,
   path: '/api/logs/SearchLogEntries/',
   credentials: true,
};

export const actions = {
   Secrets,
   SecretVersions,
   DelegationToken,
   SearchLogEntries,
};
