import { HttpMethod } from '@yandex-infracloud-ui/libs';
import { ApiAction, YpApiActions } from '../../../models/api';

function generateUuid() {
   const random = () => Math.round(Math.random() * Math.pow(2, 32)).toString(16);

   return [random(), random(), random(), random()].join('-');
}

function headers() {
   return {
      'Accept': 'application/json, text/plain, */*',
      'X-YT-Request-Format-Options': '{encode_utf8=%false}',
      'X-YT-Response-Format-Options': '{encode_utf8=%false}',
      'X-YT-Request-Id': generateUuid(),
   };
}

function onError(axiosError: any) {
   try {
      const ytRequestId = axiosError.config.headers['X-YT-Request-Id'];
      const ytError = JSON.parse(axiosError.response.headers['x-yt-error']);
      axiosError.response.data = { ytError: { request_id: ytRequestId, ...ytError } };
   } catch (e) {
      // ¯\_(ツ)_/¯
   }
}

const CreateObject: ApiAction = {
   method: HttpMethod.POST,
   path: '/ObjectService/CreateObject',
   credentials: true,
   headers,
   onError,
};

const CreateObjects: ApiAction = {
   method: HttpMethod.POST,
   path: '/ObjectService/CreateObjects',
   credentials: true,
   headers,
   onError,
};

const UpdateObject: ApiAction = {
   method: HttpMethod.POST,
   path: '/ObjectService/UpdateObject',
   credentials: true,
   headers,
   onError,
};

const RemoveObject: ApiAction = {
   method: HttpMethod.POST,
   path: '/ObjectService/RemoveObject',
   credentials: true,
   headers,
   onError,
};

const SelectObjectHistory: ApiAction = {
   method: HttpMethod.POST,
   path: '/ObjectService/SelectObjectHistory',
   credentials: true,
   headers,
   onError,
};

const SelectObjects: ApiAction = {
   method: HttpMethod.POST,
   path: '/ObjectService/SelectObjects',
   credentials: true,
   headers,
   onError,
};

const GetObjects: ApiAction = {
   method: HttpMethod.POST,
   path: '/ObjectService/GetObjects',
   credentials: true,
   headers,
   onError,
};

const GetUserAccessAllowedTo: ApiAction = {
   method: HttpMethod.POST,
   path: '/ObjectService/GetUserAccessAllowedTo',
   credentials: true,
   headers,
   onError,
};

const CheckObjectPermissions: ApiAction = {
   method: HttpMethod.POST,
   path: '/ObjectService/CheckObjectPermissions',
   credentials: true,
   headers,
   onError,
};

export const actions = {
   [YpApiActions.CreateObject]: CreateObject,
   [YpApiActions.CreateObjects]: CreateObjects,
   [YpApiActions.UpdateObject]: UpdateObject,
   [YpApiActions.RemoveObject]: RemoveObject,
   [YpApiActions.SelectObjectHistory]: SelectObjectHistory,
   [YpApiActions.SelectObjects]: SelectObjects,
   [YpApiActions.GetObjects]: GetObjects,
   [YpApiActions.GetUserAccessAllowedTo]: GetUserAccessAllowedTo,
   [YpApiActions.CheckObjectPermissions]: CheckObjectPermissions,
};
