/*
экспортируем функцию преобразования настроек действий апи сервисов в параметры fetch
*/
import { HttpMethod } from '@yandex-infracloud-ui/libs';
import { ApiAction, ApiActions, ApiServiceName } from '../../models/api';
import { apiActions } from './actions';

interface GetRequestParamsProps<T extends ApiServiceName> {
   service: T;
   action: ApiActions[T];
   pathParams?: Record<string, string>;
}

interface ApiRequestParams {
   method: HttpMethod;
   path: string;
   headers?: Record<string, string>;
   credentials?: RequestInit['credentials'];
}

export function getApiRequestParams<T extends ApiServiceName>({
   service,
   action,
   pathParams,
}: GetRequestParamsProps<T>): ApiRequestParams {
   const apiAction: ApiAction = apiActions[service][action];
   const { method, path, headers, credentials } = apiAction;
   const params: ApiRequestParams = {
      method,
      path: typeof path === 'function' ? path(pathParams ?? {}) : path,
   };
   if (headers) {
      const headersList = typeof headers === 'function' ? headers() : headers;
      params.headers = headersList;
   }
   if (credentials === true) {
      params.credentials = 'include';
   }
   return params;
}
