import { BaseApi, HttpMethod, IApiError } from '@yandex-infracloud-ui/libs';
import { Observable } from 'rxjs';

import { noop } from '../../../utils';

interface ProjectsListInput {
   filterByName: string;
   pageSize: number;
}

interface Item {
   projectId: string;
   name: string;
   description: string;
   createdAt: string;
   modifiedAt: string;
   createdBy: string;
   modifiedBy: string;
   abcService: string;
   etag: string;
   labels: Object;
   owner: string;
}

const PAGE_LIMIT = 10;

export type Projects = {
   projects: Item[];
};

export class ProjectManagerApi extends BaseApi {
   constructor(apiPrefix: string) {
      super(`${apiPrefix}/api/v3/`);
   }

   public getProjects(filterByName: string): Observable<Projects> {
      const params = {
         filterByName,
         pageSize: PAGE_LIMIT,
      };

      return this.request<ProjectsListInput, void, Projects>(HttpMethod.GET, 'projects', params);
   }

   protected getCSRF(): string {
      return '';
   }

   protected handleError(resp: Response, error: IApiError): void {
      noop();
   }
}
