import { ApiCache, BaseApi, HttpMethod, IApiError } from '@yandex-infracloud-ui/libs';
import { Observable } from 'rxjs';
import { map } from 'rxjs/operators';

import { noop } from '../../../utils';

interface NotificationChannelsInput {
   pageSize: number | undefined;
}

// Assume there are at most 1000 channels per project
const CHANNELS_PAGE_LIMIT = 1000;

interface Item {
   id: string;
   name: string;
}

export type ItemsList = Array<Item>;

export class SolomonApi extends BaseApi {
   private cache = new ApiCache();

   constructor(apiPrefix: string) {
      super(`${apiPrefix}/api/v2/`);
   }

   public getChannels(project: string): Observable<ItemsList> {
      const params = {
         pageSize: CHANNELS_PAGE_LIMIT,
      };

      return this.cache.request(`notification_channels_for_${project}`, () =>
         this.request<NotificationChannelsInput, void, { items: ItemsList }>(
            HttpMethod.GET,
            `projects/${project}/notificationChannels`,
            params,
         ).pipe(map(resp => resp?.items || [])),
      );
   }

   protected parseError(body: any, resp: Response): { status: number; message: string } {
      return {
         status: resp.status,
         message: resp.status !== 200 ? resp.statusText : body,
      };
   }

   protected getCSRF(): string {
      return '';
   }

   protected handleError(resp: Response, error: IApiError): void {
      noop();
   }
}
