import { ApiCache, BaseApi, HttpMethod, IApiError } from '@yandex-infracloud-ui/libs';
import { Observable } from 'rxjs';
import { noop } from '../../../utils';

export interface XRayStatusInput {
   id: string;
   uuid: string;
   revision: string | number;
}

export interface XRayStatus {
   issues: { low: number; high: number; medium: number };
   stage_health: 'n/a' | 'ok' | 'info' | 'warning' | 'critical';
   analysis_status: 'unknown' | 'started' | 'done' | 'failed' | 'aborted';
   analysis_status_id: number;
   stage_health_id: number;
}

export class XRayApi extends BaseApi {
   private cache = new ApiCache();

   constructor(apiPrefix: string) {
      super(`${apiPrefix}/api/v1/`);
   }

   public getXRayStatus({ id, uuid, revision }: XRayStatusInput): Observable<XRayStatus> {
      return this.request<void, void, XRayStatus>(HttpMethod.GET, `stage/${id}/${uuid}/${revision}/status`);
   }

   public getXRayStageList(): Observable<any> {
      return this.request<void, void, any>(HttpMethod.GET, `stage/list`);
   }

   protected getCSRF(): string {
      return '';
   }

   protected handleError(resp: Response, error: IApiError): void {
      noop();
   }
}
