import { Meta } from '@storybook/react';
import React from 'react';
import { RouteComponentProps } from 'react-router';

import { DevJson } from '../components/lib';
import { RouteRenderer } from './RouteRenderer';

const Page: React.FC<RouteComponentProps<{ stageId: string }>> = ({ match, location }) => (
   <>
      <DevJson open={true} summary={'match'}>
         {match}
      </DevJson>
      <DevJson open={true} summary={'location'}>
         {location}
      </DevJson>
   </>
);

export const Regular = () => (
   <RouteRenderer
      component={Page}
      path={'/stages/:stageId/deploy-tickets'}
      url={'/stages/test-release-integration-stage/deploy-tickets'}
   />
);

export default {
   title: 'stories/RouteRenderer',
} as Meta;
