import React from 'react';
import { MemoryRouter, Route, RouteComponentProps } from 'react-router';

interface Props {
   /**
    * Компонент, который должен рендерить страницу
    */
   component: React.ComponentType<RouteComponentProps<any>>;

   /**
    * Сам роут, по которому страница должна "сматчиться".
    *
    * Может содержать переменные, например /book/:book/chapters
    */
   path: string;

   /**
    * URL страницы, начиная с /
    */
   url: string;
}

/**
 * Вспомогательный компонент-обёртка для рендера компонентов-страниц,
 * которые зависят от текущего URL (например используют части роутов)
 */
export const RouteRenderer: React.FC<Props> = ({ component, path, url }) => (
   <MemoryRouter initialEntries={[url]}>
      <Route path={path} component={component} />
   </MemoryRouter>
);
