import { DeepPartial } from '../models';
import { Config } from '../services';

export const envConfig: DeepPartial<AppConfig> = {
   feedbackFormId: 47538,
   clusters: [
      { title: 'SAS', value: 'sas' },
      { title: 'MAN', value: 'man' },
      { title: 'VLA', value: 'vla' },
      { title: 'IVA', value: 'iva' },
      { title: 'MYT', value: 'myt' },
   ],
   services: [
      { name: 'abc', endpoint: 'https://abc-back.yandex-team.ru' },
      { name: 'awacs', endpoint: 'https://test-awacs.n.yandex-team.ru' },
      { name: 'deploy', endpoint: 'https://pre-ui-proxy.deploy.yandex-team.ru' },
      { name: 'deploy_auth', endpoint: 'https://deploy.yandex-team.ru/api_proxy/auth' },
      { name: 'infra', endpoint: 'https://infra-api.yandex-team.ru' },
      { name: 'logs', endpoint: 'https://pre-ui-proxy.deploy.yandex-team.ru' },
      { name: 'sandbox', endpoint: 'https://sandbox.yandex-team.ru' },
      { name: 'staff', endpoint: 'https://staff-api.yandex-team.ru' },
      { name: 'startrek', endpoint: 'https://st-api.yandex-team.ru' },
      { name: 'yasm', endpoint: 'https://yasm.yandex-team.ru' },
      { name: 'yp', endpoint: 'https://deploy.yandex-team.ru/api_proxy/yp' },
      { name: 'yp_iva', endpoint: 'https://deploy.yandex-team.ru/api_proxy/yp_iva' },
      { name: 'yp_man', endpoint: 'https://deploy.yandex-team.ru/api_proxy/yp_man' },
      { name: 'yp_myt', endpoint: 'https://deploy.yandex-team.ru/api_proxy/yp_myt' },
      { name: 'yp_sas', endpoint: 'https://deploy.yandex-team.ru/api_proxy/yp_sas' },
      { name: 'yp_sas_test', endpoint: 'https://deploy.yandex-team.ru/api_proxy/yp_sas_test' },
      { name: 'yp_vla', endpoint: 'https://deploy.yandex-team.ru/api_proxy/yp_vla' },
      { name: 'infra', endpoint: 'https://infra-api.yandex-team.ru' },
      { name: 'infra_components', endpoint: 'https://sidecars-updater-test.in.yandex-team.ru' },
      { name: 'xray', endpoint: 'https://xray.sec.yandex-team.ru' },
      { name: 'solomon', endpoint: 'https://solomon.yandex-team.ru' },
      { name: 'project_manager', endpoint: 'https://pm.yandex-team.ru' },
      { name: 'infra_doctor', endpoint: 'https://infra-doctor.yandex-team.ru' },
   ],
};

export const config = new Config(envConfig as AppConfig);

let patched = false;

export function patchGlobalConfig() {
   if (patched) {
      return;
   }
   window.CONFIG = envConfig as AppConfig;

   patched = true;
}
