import { Meta } from '@storybook/react';
import {
   YCSelect,
   YCSelectGetItemsArgs,
   YCSelectGetItemsArgsFetchItems,
   YCSelectGetItemsArgsInitItems,
   YCSelectItem,
} from '@yandex-data-ui/common';
import { DevJson, isEmpty } from '@yandex-infracloud-ui/libs';
import React, { useCallback, useMemo, useState } from 'react';
import { LegoTextInput } from '../../_lego';

export const TextInputField = () => {
   const [value, setValue] = useState('old value');

   const handleChange = useCallback((v: string) => {
      setValue(v);
   }, []);

   return (
      <div data-test={'TextInputField'}>
         <LegoTextInput text={value} onChange={handleChange} />

         <DevJson open={true}>{value}</DevJson>
      </div>
   );
};

export const YCSelectField = () => {
   const [value, setValue] = useState('Option2');

   const items = useMemo(() => ['Option1', 'Option2', 'Option3'], []);

   const getItems = useCallback(
      (args: YCSelectGetItemsArgs): Promise<{ items: YCSelectItem[] }> => {
         const initArgs = args as YCSelectGetItemsArgsInitItems;
         if (!isEmpty(initArgs.exactKeys)) {
            return Promise.resolve({
               items: initArgs.exactKeys
                  .map(v => {
                     const item = items.find(i => v === i);

                     return item ? { value: item, title: item } : null;
                  })
                  .filter(Boolean) as YCSelectItem[],
            });
         }
         const fetchArgs = args as YCSelectGetItemsArgsFetchItems;
         return Promise.resolve({
            items: items
               .filter(i => i.includes(fetchArgs.searchPattern ?? ''))
               .map(item => ({ value: item, title: item } as YCSelectItem)),
         });
      },
      [items],
   );

   const handleChange = useCallback((v: string) => {
      setValue(v);
   }, []);

   return (
      <div data-test={'YCSelectField'}>
         <YCSelect onUpdate={handleChange} getItems={getItems} value={value} />

         <DevJson open={true}>{value}</DevJson>
      </div>
   );
};

export const YCSelectMultipleField = () => {
   const [value, setValue] = useState(['Option2', 'Option3']);
   const [itemValues, setItemValues] = useState(['Option1', 'Option2', 'Option3', 'Option4']);

   const items = useMemo(
      () =>
         itemValues.sort().map(v => ({
            value: v,
            title: v,
         })),
      [itemValues],
   );

   const handleChange = useCallback((v: string[]) => {
      setValue(v);
   }, []);

   const handleAddItem = useCallback(
      (v: string) => {
         if (!itemValues.map(item => item.toLowerCase()).includes(v.toLowerCase())) {
            setItemValues([...itemValues, v]);
         }
      },
      [itemValues],
   );

   return (
      <div data-test={'YCSelectMultipleField'}>
         <YCSelect onUpdate={handleChange} items={items} value={value} type={'multiple'} addItem={handleAddItem} />

         <DevJson open={true}>{value}</DevJson>
      </div>
   );
};

export default {
   title: 'cypress',
} as Meta;
