import * as React from 'react';

import { ApiServices, ApiServicesContext } from '../../services';
import { setAppConfig } from '../../services/Config';
import { config, envConfig, patchGlobalConfig } from '../configForStorybook';

const apiServices = new ApiServices(config);

export function apiServicesContextDecorator(story: any): JSX.Element {
   patchGlobalConfig();
   setAppConfig(envConfig as AppConfig);

   return <ApiServicesContext.Provider value={apiServices}>{story()}</ApiServicesContext.Provider>;
}
