/* eslint-disable global-require */
import { configure, Lang } from '@yandex-cloud/uikit';
import { CommonProvider } from '@yandex-data-ui/common';
import { configure as commonConfigure, Lang as CommonLang } from '@yandex-data-ui/common/build/esm/utils/configure';
import { useDarkMode } from 'storybook-dark-mode';

import '../../design/index.css';
import '../../design/storybook-preview.css';

// Common library i18n
configure({ lang: Lang.En }); // for uikit
commonConfigure({ lang: CommonLang.En }); // for common

export function globalStylesDecorator(story: any) {
   // eslint-disable-next-line react-hooks/rules-of-hooks
   const isDark = useDarkMode();

   return (
      <CommonProvider mobile={false} theme={isDark ? 'dark' : 'light'}>
         {story()}
      </CommonProvider>
   );
}
