import { DeepPartial } from '../models';
import { EAccessControlAction, EAccessControlPermission, EObjectType, TStage } from '../proto-typings';

// noinspection DuplicatedCode,SpellCheckingInspection
export const testStage1: TStage = ({
   labels: {
      deploy_engine: 'env_controller',
      stagectl_epoch: 96,
      stagectl_vcs: {
         svn_branch: 'stage_controller/stable-47-1',
         svn_revision: 6404822,
         svn_tag: '',
      },
   },
   status: {
      deploy_units: {
         Deploy_UI: {
            current_target: {
               network_defaults: {
                  network_id: '_SEARCHSAND_',
               },
               tvm_config: {
                  client_port: 2,
               },
               images_for_boxes: {
                  Docker: {
                     registry_host: 'registry.yandex.net',
                     name: 'deploy.ui/deploy-ui',
                     tag: '0.1.5-releases-links',
                  },
               },
               logbroker_config: {},
               replica_set: {
                  replica_set_template: {
                     pod_template_spec: {
                        spec: {
                           resource_requests: {
                              vcpu_guarantee: 100,
                              vcpu_limit: 100,
                              memory_guarantee: 1073741824,
                              memory_limit: 1073741824,
                           },
                           ip6_address_requests: [
                              {
                                 network_id: '_SEARCHSAND_',
                                 vlan_id: 'backbone',
                                 enable_dns: true,
                              },
                              {
                                 network_id: '_SEARCHSAND_',
                                 vlan_id: 'fastbone',
                                 enable_dns: true,
                              },
                           ],
                           disk_volume_requests: [
                              {
                                 id: 'khoden-deploy-ui-stage-disk-0',
                                 labels: {
                                    used_by_infra: true,
                                 },
                                 storage_class: 'hdd',
                                 quota_policy: {
                                    capacity: 3221225472,
                                 },
                              },
                           ],
                           pod_agent_payload: {
                              spec: {
                                 resources: {},
                                 workloads: [
                                    {
                                       id: 'supervisord',
                                       env: [
                                          {
                                             name: 'CONSOLE_ENV',
                                             value: {
                                                literal_env: {
                                                   value: 'ext-pre',
                                                },
                                             },
                                          },
                                       ],
                                       readiness_check: {
                                          tcp_check: {
                                             port: 80,
                                          },
                                       },
                                       box_ref: 'Docker',
                                       liveness_check: {
                                          http_get: {
                                             port: 80,
                                             path: '/ping',
                                             expected_answer: 'pong',
                                          },
                                       },
                                       start: {
                                          command_line: '/bin/bash /opt/app/start.sh',
                                       },
                                       transmit_logs: true,
                                    },
                                 ],
                                 boxes: [
                                    {
                                       id: 'Docker',
                                       rootfs: {},
                                    },
                                 ],
                                 mutable_workloads: [
                                    {
                                       workload_ref: 'supervisord',
                                    },
                                 ],
                              },
                           },
                           host_infra: {
                              monitoring: {},
                           },
                        },
                     },
                     constraints: {
                        antiaffinity_constraints: [
                           {
                              key: 'node',
                              max_pods: 1,
                           },
                        ],
                     },
                  },
                  per_cluster_settings: {
                     man: {
                        pod_count: 1,
                        deployment_strategy: {
                           max_unavailable: 1,
                        },
                     },
                     sas: {
                        pod_count: 1,
                        deployment_strategy: {
                           max_unavailable: 1,
                        },
                     },
                  },
               },
            },
            in_progress: {
               status: 'false',
               last_transition_time: {
                  seconds: 1587023084,
                  nanos: 61163000,
               },
            },
            ready: {
               status: 'true',
               last_transition_time: {
                  seconds: 1587023084,
                  nanos: 61163000,
               },
            },
            progress: {
               pods_ready: 2,
               pods_total: 2,
            },
            target_revision: 28,
            target_spec_timestamp: 1703994547383566300,
            yasm_itype: 'deploy',
            replica_set: {
               cluster_statuses: {
                  man: {
                     replica_set_id: 'khoden-deploy-ui-stage.Deploy_UI',
                     endpoint_set_ids: ['khoden-deploy-ui-stage.Deploy_UI'],
                  },
                  sas: {
                     replica_set_id: 'khoden-deploy-ui-stage.Deploy_UI',
                     endpoint_set_ids: ['khoden-deploy-ui-stage.Deploy_UI'],
                  },
               },
            },
            failed: {
               status: 'false',
               last_transition_time: {
                  seconds: 1587023084,
                  nanos: 61163000,
               },
            },
         },
      },
      revision: 28,
      validated: {
         status: 'true',
         last_transition_time: {
            seconds: 1584029717,
            nanos: 718201000,
         },
      },
      spec_timestamp: 1703994547383566300,
   },
   spec: {
      account_id: 'abc:service:3494',
      revision: 28,
      deploy_units: {
         Deploy_UI: {
            network_defaults: {
               network_id: '_SEARCHSAND_',
            },
            tvm_config: {},
            images_for_boxes: {
               Docker: {
                  registry_host: 'registry.yandex.net',
                  name: 'deploy.ui/deploy-ui',
                  tag: '0.1.5-releases-links',
               },
            },
            replica_set: {
               replica_set_template: {
                  pod_template_spec: {
                     spec: {
                        resource_requests: {
                           vcpu_guarantee: 100,
                           vcpu_limit: 100,
                           memory_guarantee: 1073741824,
                           memory_limit: 1073741824,
                        },
                        ip6_address_requests: [
                           {
                              network_id: '_SEARCHSAND_',
                              vlan_id: 'backbone',
                              enable_dns: true,
                           },
                           {
                              network_id: '_SEARCHSAND_',
                              vlan_id: 'fastbone',
                              enable_dns: true,
                           },
                        ],
                        disk_volume_requests: [
                           {
                              id: 'khoden-deploy-ui-stage-disk-0',
                              labels: {
                                 used_by_infra: true,
                              },
                              storage_class: 'hdd',
                              quota_policy: {
                                 capacity: 3221225472,
                              },
                           },
                        ],
                        pod_agent_payload: {
                           spec: {
                              resources: {},
                              workloads: [
                                 {
                                    id: 'supervisord',
                                    env: [
                                       {
                                          name: 'CONSOLE_ENV',
                                          value: {
                                             literal_env: {
                                                value: 'ext-pre',
                                             },
                                          },
                                       },
                                    ],
                                    readiness_check: {
                                       tcp_check: {
                                          port: 80,
                                       },
                                    },
                                    box_ref: 'Docker',
                                    liveness_check: {
                                       http_get: {
                                          port: 80,
                                          path: '/ping',
                                          expected_answer: 'pong',
                                       },
                                    },
                                    start: {
                                       command_line: '/bin/bash /opt/app/start.sh',
                                    },
                                    transmit_logs: true,
                                 },
                              ],
                              boxes: [
                                 {
                                    id: 'Docker',
                                    rootfs: {},
                                 },
                              ],
                              mutable_workloads: [
                                 {
                                    workload_ref: 'supervisord',
                                 },
                              ],
                           },
                        },
                        host_infra: {
                           monitoring: {},
                        },
                     },
                  },
                  constraints: {
                     antiaffinity_constraints: [
                        {
                           key: 'node',
                           max_pods: 1,
                        },
                     ],
                  },
               },
               per_cluster_settings: {
                  man: {
                     pod_count: 1,
                     deployment_strategy: {
                        max_unavailable: 1,
                     },
                  },
                  sas: {
                     pod_count: 1,
                     deployment_strategy: {
                        max_unavailable: 1,
                     },
                  },
               },
            },
         },
      },
      revision_info: {
         description: 'WIP releases: add links to release, ticket',
      },
   },
   meta: {
      inherit_acl: true,
      type: EObjectType.OT_STAGE,
      acl: [
         {
            action: EAccessControlAction.ACA_ALLOW,
            subjects: ['root'],
            permissions: [
               EAccessControlPermission.ACP_READ,
               EAccessControlPermission.ACA_WRITE,
               EAccessControlPermission.ACA_CREATE,
               EAccessControlPermission.ACA_SSH_ACCESS,
               EAccessControlPermission.ACA_ROOT_SSH_ACCESS,
               EAccessControlPermission.ACP_READ_SECRETS,
            ],
         },
      ],
      creation_time: 1579594461672889,
      project_id: '',
      id: '47b7f0r1zsf3hhfy',
      uuid: '61b4d170-6d1413ae-56b16660-d303d414',
   },
   annotations: {},
} as DeepPartial<TStage>) as any;

// noinspection DuplicatedCode,SpellCheckingInspection
export const testStage2: TStage = ({
   labels: {
      deploy_engine: 'env_controller',
      stagectl_epoch: 150,
      stagectl_vcs: {
         svn_branch: 'stage_controller/stable-57-1',
         svn_revision: 6598110,
         svn_tag: '',
      },
   },
   status: {
      deploy_units: {
         DeployUnit1: {
            current_target: {
               network_defaults: {
                  network_id: '_SEARCHSAND_',
               },
               tvm_config: {
                  client_port: 2,
               },
               endpoint_sets: [
                  {
                     port: 80,
                  },
               ],
               logbroker_config: {},
               replica_set: {
                  replica_set_template: {
                     pod_template_spec: {
                        spec: {
                           resource_requests: {
                              vcpu_guarantee: 100,
                              vcpu_limit: 100,
                              memory_guarantee: 1073741824,
                              memory_limit: 1073741824,
                           },
                           ip6_address_requests: [
                              {
                                 network_id: '_SEARCHSAND_',
                                 vlan_id: 'backbone',
                                 enable_dns: true,
                              },
                              {
                                 network_id: '_SEARCHSAND_',
                                 vlan_id: 'fastbone',
                                 enable_dns: true,
                              },
                           ],
                           disk_volume_requests: [
                              {
                                 id: 'test-release-integration-stage-disk-0',
                                 labels: {
                                    used_by_infra: true,
                                 },
                                 storage_class: 'hdd',
                                 quota_policy: {
                                    capacity: 3221225472,
                                 },
                              },
                           ],
                           pod_agent_payload: {
                              spec: {
                                 resources: {
                                    layers: [
                                       {
                                          id: 'base-layer-0',
                                          checksum: 'EMPTY:',
                                          url: 'sbr:2061235470',
                                       },
                                       {
                                          id: 'simple_http_server',
                                          checksum: 'EMPTY:',
                                          url: 'sbr:755375039',
                                       },
                                       {
                                          id: 'my-layer',
                                          meta: {
                                             sandbox_resource: {
                                                task_type: 'SAMPLE_RELEASE_TO_YA_DEPLOY_2',
                                                task_id: '636599712',
                                                resource_type: 'SAMPLE_RELEASE_INTEGRATION_LAYER',
                                                resource_id: '1414625542',
                                             },
                                          },
                                          checksum: 'MD5:2939a954c737b39bd72e235e3967e069',
                                          url: 'rbtorrent:9a284066d1f40b2ed1d9611dad78fe7afe8deddf',
                                       },
                                    ],
                                    static_resources: [
                                       {
                                          id: 'my-static',
                                          meta: {
                                             sandbox_resource: {
                                                task_type: 'SAMPLE_RELEASE_TO_YA_DEPLOY_2',
                                                task_id: '636599712',
                                                resource_type: 'SAMPLE_RELEASE_INTEGRATION_STATIC',
                                                resource_id: '1414625516',
                                             },
                                          },
                                          verification: {
                                             checksum: 'MD5:13a0db776ed374fd4fe168029555ae3e',
                                             check_period_ms: 180000,
                                          },
                                          url: 'rbtorrent:1b2120e9e8c0466409deb8b86699f71386694df4',
                                       },
                                    ],
                                 },
                                 workloads: [
                                    {
                                       id: 'Box1-Workload1',
                                       env: [
                                          {
                                             name: 'mySuperVariable',
                                             value: {
                                                literal_env: {
                                                   value: 'mySuperValue',
                                                },
                                             },
                                          },
                                          {
                                             name: 'nametest',
                                             value: {
                                                secret_env: {
                                                   id: 'reddi-test',
                                                   alias:
                                                      'sec-01d6bkr38deswha5zrszemkm50:ver-01dvzmdb0pxdg9z1t60few7s70',
                                                },
                                             },
                                          },
                                       ],
                                       readiness_check: {
                                          tcp_check: {
                                             port: 80,
                                          },
                                       },
                                       box_ref: 'Box1',
                                       start: {
                                          command_line: "/simple_http_server 80 'Hello my dear @reddi!'",
                                       },
                                       transmit_logs: true,
                                    },
                                 ],
                                 boxes: [
                                    {
                                       id: 'Box1',
                                       rootfs: {
                                          layer_refs: ['base-layer-0', 'simple_http_server', 'my-layer'],
                                       },
                                       static_resources: [
                                          {
                                             resource_ref: 'my-static',
                                             mount_point: '/tmp/static',
                                          },
                                       ],
                                    },
                                 ],
                                 mutable_workloads: [
                                    {
                                       workload_ref: 'Box1-Workload1',
                                    },
                                 ],
                              },
                           },
                           secrets: {
                              'sec-01d6bkr38deswha5zrszemkm50:ver-01dvzmdb0pxdg9z1t60few7s70': {
                                 secret_id: 'sec-01d6bkr38deswha5zrszemkm50',
                                 secret_version: 'ver-01dvzmdb0pxdg9z1t60few7s70',
                                 delegation_token: 'xTJ6-Mg-ZaxOCU-3X0FnMVsQEO_BKvFrJVW6cMPxHAA.1.b5f441e03a5c2095',
                              },
                           },
                           host_infra: {
                              monitoring: {},
                           },
                        },
                     },
                     constraints: {
                        antiaffinity_constraints: [
                           {
                              key: 'rack',
                              max_pods: 1,
                           },
                        ],
                     },
                  },
                  per_cluster_settings: {
                     sas: {
                        pod_count: 1,
                        deployment_strategy: {
                           max_unavailable: 1,
                        },
                     },
                     vla: {
                        pod_count: 0,
                        deployment_strategy: {
                           max_unavailable: 1,
                        },
                     },
                  },
               },
            },
            in_progress: {
               status: 'true',
               reason: 'REPLICA_SET_UPDATING_PODS',
               last_transition_time: {
                  seconds: 1586081791,
                  nanos: 781744000,
               },
            },
            ready: {
               status: 'false',
               reason: 'REPLICA_SET_UPDATING_PODS',
               last_transition_time: {
                  seconds: 1586081791,
                  nanos: 781744000,
               },
            },
            progress: {
               pods_total: 1,
            },
            target_revision: 29,
            target_spec_timestamp: 1703963565636976600,
            yasm_itype: 'deploy',
            replica_set: {
               cluster_statuses: {
                  sas: {
                     replica_set_id: 'test-release-integration-stage.DeployUnit1',
                     endpoint_set_ids: ['test-release-integration-stage.DeployUnit1'],
                  },
                  vla: {
                     replica_set_id: 'test-release-integration-stage.DeployUnit1',
                     endpoint_set_ids: ['test-release-integration-stage.DeployUnit1'],
                  },
               },
            },
            failed: {
               status: 'false',
               last_transition_time: {
                  seconds: 1586081791,
                  nanos: 781744000,
               },
            },
         },
      },
      revision: 29,
      validated: {
         status: 'true',
         last_transition_time: {
            seconds: 1583313802,
            nanos: 339520000,
         },
      },
      spec_timestamp: 1703963565636976600,
   },
   spec: {
      account_id: 'abc:service:5996',
      revision: 29,
      deploy_units: {
         DeployUnit1: {
            network_defaults: {
               network_id: '_SEARCHSAND_',
            },
            tvm_config: {},
            endpoint_sets: [
               {
                  port: 80,
               },
            ],
            replica_set: {
               replica_set_template: {
                  pod_template_spec: {
                     spec: {
                        resource_requests: {
                           vcpu_guarantee: 100,
                           vcpu_limit: 100,
                           memory_guarantee: 1073741824,
                           memory_limit: 1073741824,
                        },
                        ip6_address_requests: [
                           {
                              network_id: '_SEARCHSAND_',
                              vlan_id: 'backbone',
                              enable_dns: true,
                           },
                           {
                              network_id: '_SEARCHSAND_',
                              vlan_id: 'fastbone',
                              enable_dns: true,
                           },
                        ],
                        disk_volume_requests: [
                           {
                              id: 'test-release-integration-stage-disk-0',
                              labels: {
                                 used_by_infra: true,
                              },
                              storage_class: 'hdd',
                              quota_policy: {
                                 capacity: 3221225472,
                              },
                           },
                        ],
                        pod_agent_payload: {
                           spec: {
                              resources: {
                                 layers: [
                                    {
                                       id: 'base-layer-0',
                                       checksum: 'EMPTY:',
                                       url: 'sbr:2061235470',
                                    },
                                    {
                                       id: 'simple_http_server',
                                       checksum: 'EMPTY:',
                                       url: 'sbr:755375039',
                                    },
                                    {
                                       id: 'my-layer',
                                       meta: {
                                          sandbox_resource: {
                                             task_type: 'SAMPLE_RELEASE_TO_YA_DEPLOY_2',
                                             task_id: '636599712',
                                             resource_type: 'SAMPLE_RELEASE_INTEGRATION_LAYER',
                                             resource_id: '1414625542',
                                          },
                                       },
                                       checksum: 'MD5:2939a954c737b39bd72e235e3967e069',
                                       url: 'rbtorrent:9a284066d1f40b2ed1d9611dad78fe7afe8deddf',
                                    },
                                 ],
                                 static_resources: [
                                    {
                                       id: 'my-static',
                                       meta: {
                                          sandbox_resource: {
                                             task_type: 'SAMPLE_RELEASE_TO_YA_DEPLOY_2',
                                             task_id: '636599712',
                                             resource_type: 'SAMPLE_RELEASE_INTEGRATION_STATIC',
                                             resource_id: '1414625516',
                                          },
                                       },
                                       verification: {
                                          checksum: 'MD5:13a0db776ed374fd4fe168029555ae3e',
                                          check_period_ms: 180000,
                                       },
                                       url: 'rbtorrent:1b2120e9e8c0466409deb8b86699f71386694df4',
                                    },
                                 ],
                              },
                              workloads: [
                                 {
                                    id: 'Box1-Workload1',
                                    env: [
                                       {
                                          name: 'mySuperVariable',
                                          value: {
                                             literal_env: {
                                                value: 'mySuperValue',
                                             },
                                          },
                                       },
                                       {
                                          name: 'nametest',
                                          value: {
                                             secret_env: {
                                                id: 'reddi-test',
                                                alias: 'sec-01d6bkr38deswha5zrszemkm50:ver-01dvzmdb0pxdg9z1t60few7s70',
                                             },
                                          },
                                       },
                                    ],
                                    readiness_check: {
                                       tcp_check: {
                                          port: 80,
                                       },
                                    },
                                    box_ref: 'Box1',
                                    start: {
                                       command_line: "/simple_http_server 80 'Hello my dear @reddi!'",
                                    },
                                    transmit_logs: true,
                                 },
                              ],
                              boxes: [
                                 {
                                    id: 'Box1',
                                    rootfs: {
                                       layer_refs: ['base-layer-0', 'simple_http_server', 'my-layer'],
                                    },
                                    static_resources: [
                                       {
                                          resource_ref: 'my-static',
                                          mount_point: '/tmp/static',
                                       },
                                    ],
                                 },
                              ],
                              mutable_workloads: [
                                 {
                                    workload_ref: 'Box1-Workload1',
                                 },
                              ],
                           },
                        },
                        secrets: {
                           'sec-01d6bkr38deswha5zrszemkm50:ver-01dvzmdb0pxdg9z1t60few7s70': {
                              secret_id: 'sec-01d6bkr38deswha5zrszemkm50',
                              secret_version: 'ver-01dvzmdb0pxdg9z1t60few7s70',
                              delegation_token: 'xTJ6-Mg-ZaxOCU-3X0FnMVsQEO_BKvFrJVW6cMPxHAA.1.b5f441e03a5c2095',
                           },
                        },
                        host_infra: {
                           monitoring: {},
                        },
                     },
                  },
                  constraints: {
                     antiaffinity_constraints: [
                        {
                           key: 'rack',
                           max_pods: 1,
                        },
                     ],
                  },
               },
               per_cluster_settings: {
                  sas: {
                     pod_count: 1,
                     deployment_strategy: {
                        max_unavailable: 1,
                     },
                  },
                  vla: {
                     deployment_strategy: {
                        max_unavailable: 1,
                     },
                  },
               },
            },
         },
      },
      revision_info: {
         description: 'kitty 106',
      },
   },
   meta: {
      inherit_acl: true,
      type: 'stage',
      acl: [
         {
            action: 'allow',
            permissions: ['read', 'write', 'create', 'ssh_access', 'root_ssh_access', 'read_secrets'],
            subjects: ['reddi', 'alonger', 'khoden', 'dmitriyt', 'robot-drug-deploy', 'robot-deploy-test'],
         },
      ],
      creation_time: 1583311077183970,
      project_id: 'test-release-integration-stage',
      id: 'test-release-integration-stage',
      uuid: '6dcab76-a1453e2f-2e20a931-56744d33',
   },
   annotations: {
      project: 'test-release-integration-stage',
   },
} as DeepPartial<TStage>) as any;

// noinspection DuplicatedCode,SpellCheckingInspection
export const testSecretsStage: TStage = ({
   meta: {
      inherit_acl: true,
      type: 'stage',
      project_id: 'khoden-deploy-ui',
      id: 'khoden-secrets',
      creation_time: 1611932899299884,
      account_id: 'abc:service:3737',
      uuid: '45c9881e-b5e3cc91-3b048e96-324bf9d6',
   },
   labels: {
      deploy_engine: 'env_controller',
      du_sidecar_target_revision: {
         du_autogen_secrets: {
            logbrokerToolsLayer: 2035657882,
            podBin: 2051752541,
         },
         du_manual_secrets: {
            podBin: 2051752541,
         },
      },
      notifications_last_timestamp: 1615300301999722000,
      stagectl_epoch: 589,
      stagectl_vcs: {
         svn_branch: 'stage_controller/stable-108-2',
         svn_revision: 7951591,
         svn_tag: 'stage_controller/stable-108-2',
      },
      tags: [
         'test',
         'khoden',
         'dev',
         'deploy',
         'ui',
         'very-long-tag1',
         'very-long-tag2',
         'very-long-tag3',
         'very-long-tag4',
      ],
   },
   spec: {
      account_id: 'abc:service:3737',
      revision: 13,
      deploy_units: {
         du_empty_secrets: {
            network_defaults: {
               network_id: '_YA_DEPLOY_NETS_',
            },
            endpoint_sets: [
               {
                  port: 80,
               },
            ],
            revision: 1,
            replica_set: {
               replica_set_template: {
                  pod_template_spec: {
                     spec: {
                        resource_requests: {
                           vcpu_guarantee: 100,
                           vcpu_limit: 100,
                           memory_guarantee: 1073741824,
                           memory_limit: 1073741824,
                           network_bandwidth_guarantee: 31457280,
                           network_bandwidth_limit: 31457280,
                        },
                        disk_volume_requests: [
                           {
                              id: 'disk-0',
                              labels: {
                                 used_by_infra: true,
                              },
                              storage_class: 'hdd',
                              quota_policy: {
                                 capacity: 3221225472,
                                 bandwidth_guarantee: 15728640,
                                 bandwidth_limit: 31457280,
                              },
                           },
                        ],
                        pod_agent_payload: {
                           spec: {
                              resources: {
                                 layers: [
                                    {
                                       id: 'layer',
                                       checksum: 'EMPTY:',
                                       url: 'sbr:2061235470',
                                    },
                                    {
                                       id: 'simple_http_server',
                                       checksum: 'EMPTY:',
                                       url: 'sbr:755375039',
                                    },
                                 ],
                              },
                              workloads: [
                                 {
                                    id: 'workload',
                                    readiness_check: {
                                       tcp_check: {
                                          port: 80,
                                       },
                                    },
                                    box_ref: 'box',
                                    start: {
                                       command_line: "/simple_http_server 80 'Hello my dear @khoden!'",
                                    },
                                    transmit_logs: true,
                                 },
                              ],
                              boxes: [
                                 {
                                    id: 'box',
                                    rootfs: {
                                       layer_refs: ['layer', 'simple_http_server'],
                                    },
                                 },
                              ],
                              mutable_workloads: [
                                 {
                                    workload_ref: 'workload',
                                 },
                              ],
                           },
                        },
                     },
                  },
                  constraints: {
                     antiaffinity_constraints: [
                        {
                           key: 'rack',
                           max_pods: 1,
                        },
                     ],
                  },
               },
               per_cluster_settings: {
                  sas: {
                     pod_count: 1,
                     deployment_strategy: {
                        max_unavailable: 1,
                     },
                  },
               },
            },
         },
         du_manual_secrets: {
            network_defaults: {
               network_id: '_YA_DEPLOY_NETS_',
            },
            endpoint_sets: [
               {
                  port: 80,
               },
            ],
            revision: 8,
            replica_set: {
               replica_set_template: {
                  pod_template_spec: {
                     spec: {
                        resource_requests: {
                           vcpu_guarantee: 100,
                           vcpu_limit: 100,
                           memory_guarantee: 1073741824,
                           memory_limit: 1073741824,
                           network_bandwidth_guarantee: 31457280,
                           network_bandwidth_limit: 31457280,
                        },
                        disk_volume_requests: [
                           {
                              id: 'disk-0',
                              labels: {
                                 used_by_infra: true,
                              },
                              storage_class: 'hdd',
                              quota_policy: {
                                 capacity: 3221225472,
                                 bandwidth_guarantee: 15728640,
                                 bandwidth_limit: 31457280,
                              },
                           },
                        ],
                        pod_agent_payload: {
                           spec: {
                              resources: {
                                 layers: [
                                    {
                                       id: 'layer',
                                       checksum: 'EMPTY:',
                                       url: 'sbr:2061235470',
                                    },
                                    {
                                       id: 'simple_http_server',
                                       checksum: 'EMPTY:',
                                       url: 'sbr:755375039',
                                    },
                                 ],
                              },
                              workloads: [
                                 {
                                    id: 'workload',
                                    env: [
                                       {
                                          name: 'YT_TOKEN',
                                          value: {
                                             secret_env: {
                                                id: 'YT_TOKEN',
                                                alias: 'INFRACLOUDUI',
                                             },
                                          },
                                       },
                                       {
                                          name: 'DENIED_VAR',
                                          value: {
                                             secret_env: {
                                                id: 'reddi-test',
                                                alias: 'DENIED_SECRET',
                                             },
                                          },
                                       },
                                    ],
                                    readiness_check: {
                                       tcp_check: {
                                          port: 80,
                                       },
                                    },
                                    box_ref: 'box',
                                    start: {
                                       command_line: "/simple_http_server 80 'Hello my dear @khoden!'",
                                    },
                                 },
                              ],
                              boxes: [
                                 {
                                    id: 'box',
                                    rootfs: {
                                       layer_refs: ['layer', 'simple_http_server'],
                                    },
                                    env: [
                                       {
                                          name: 'YT_TOKEN',
                                          value: {
                                             secret_env: {
                                                id: 'YT_TOKEN',
                                                alias: 'INFRACLOUDUI',
                                             },
                                          },
                                       },
                                       {
                                          name: 'FONTAWESOME_NPM_AUTH_TOKEN',
                                          value: {
                                             secret_env: {
                                                id: 'FONTAWESOME_NPM_AUTH_TOKEN',
                                                alias: 'INFRACLOUDUI',
                                             },
                                          },
                                       },
                                       {
                                          name: 'ARC_TOKEN',
                                          value: {
                                             secret_env: {
                                                id: 'ARC_TOKEN',
                                                alias: 'INFRACLOUDUI_new',
                                             },
                                          },
                                       },
                                    ],
                                 },
                              ],
                              mutable_workloads: [
                                 {
                                    workload_ref: 'workload',
                                 },
                              ],
                           },
                        },
                        secrets: {
                           INFRACLOUDUI: {
                              secret_id: 'sec-01dec420c9rpdgdc9p3astjs0x',
                              secret_version: 'ver-01erj3s88hsyahp063efjsd12m',
                              delegation_token: 'kdVLi5hao80j_mXlJcCCoJY3Pir27Rvg0n8WX8J3d04.1.dcd524be52af6b63',
                           },
                           // дубль секрета с другим алиасом
                           YET_ANOTHER_DENIED_SECRET_ALIAS: {
                              secret_id: 'sec-01d6bkr38deswha5zrszemkm50',
                              secret_version: 'ver-01dvzmdb0pxdg9z1t60few7s70',
                              delegation_token: 'xTJ6-Mg-ZaxOCU-3X0FnMVsQEO_BKvFrJVW6cMPxHAA.1.b5f441e03a5c2095',
                           },
                           DENIED_SECRET: {
                              secret_id: 'sec-01d6bkr38deswha5zrszemkm50',
                              secret_version: 'ver-01dvzmdb0pxdg9z1t60few7s70',
                              delegation_token: 'xTJ6-Mg-ZaxOCU-3X0FnMVsQEO_BKvFrJVW6cMPxHAA.1.b5f441e03a5c2095',
                           },
                        },
                        secret_refs: {
                           INFRACLOUDUI_new: {
                              secret_id: 'sec-01dec420c9rpdgdc9p3astjs0x',
                              secret_version: 'ver-01erj3s88hsyahp063efjsd12m',
                           },
                        },
                     },
                  },
                  constraints: {
                     antiaffinity_constraints: [
                        {
                           key: 'rack',
                           max_pods: 1,
                        },
                     ],
                  },
               },
               per_cluster_settings: {
                  sas: {
                     pod_count: 1,
                     deployment_strategy: {
                        max_unavailable: 1,
                     },
                  },
               },
            },
            pod_agent_sandbox_info: {
               revision: 2051752541,
            },
         },
         du_autogen_secrets: {
            network_defaults: {
               network_id: '_YA_DEPLOY_NETS_',
            },
            endpoint_sets: [
               {
                  port: 80,
               },
            ],
            revision: 4,
            replica_set: {
               replica_set_template: {
                  pod_template_spec: {
                     spec: {
                        resource_requests: {
                           vcpu_guarantee: 100,
                           vcpu_limit: 100,
                           memory_guarantee: 1073741824,
                           memory_limit: 1073741824,
                           network_bandwidth_guarantee: 31457280,
                           network_bandwidth_limit: 31457280,
                        },
                        disk_volume_requests: [
                           {
                              id: 'disk-0',
                              labels: {
                                 used_by_infra: true,
                              },
                              storage_class: 'hdd',
                              quota_policy: {
                                 capacity: 3221225472,
                                 bandwidth_guarantee: 15728640,
                                 bandwidth_limit: 31457280,
                              },
                           },
                        ],
                        pod_agent_payload: {
                           spec: {
                              resources: {
                                 layers: [
                                    {
                                       id: 'layer',
                                       checksum: 'EMPTY:',
                                       url: 'sbr:2061235470',
                                    },
                                    {
                                       id: 'simple_http_server',
                                       checksum: 'EMPTY:',
                                       url: 'sbr:755375039',
                                    },
                                 ],
                              },
                              workloads: [
                                 {
                                    id: 'workload',
                                    env: [
                                       {
                                          name: 'YT_TOKEN',
                                          value: {
                                             secret_env: {
                                                id: 'YT_TOKEN',
                                                alias: 'sec-01dec420c9rpdgdc9p3astjs0x:ver-01e98vbvt1c0gs9tzpfprsavab',
                                             },
                                          },
                                       },
                                    ],
                                    readiness_check: {
                                       tcp_check: {
                                          port: 80,
                                       },
                                    },
                                    box_ref: 'box',
                                    start: {
                                       command_line: "/simple_http_server 80 'Hello my dear @khoden!'",
                                    },
                                    transmit_logs: true,
                                 },
                              ],
                              boxes: [
                                 {
                                    id: 'box',
                                    rootfs: {
                                       layer_refs: ['layer', 'simple_http_server'],
                                    },
                                    env: [
                                       {
                                          name: 'YT_TOKEN',
                                          value: {
                                             secret_env: {
                                                id: 'YT_TOKEN',
                                                alias: 'sec-01dec420c9rpdgdc9p3astjs0x:ver-01ekmg8e2ywkvbb4d821a5ah1j',
                                             },
                                          },
                                       },
                                       {
                                          name: 'FONTAWESOME_NPM_AUTH_TOKEN',
                                          value: {
                                             secret_env: {
                                                id: 'FONTAWESOME_NPM_AUTH_TOKEN',
                                                alias: 'sec-01dec420c9rpdgdc9p3astjs0x:ver-01ekmg8e2ywkvbb4d821a5ah1j',
                                             },
                                          },
                                       },
                                    ],
                                 },
                              ],
                              mutable_workloads: [
                                 {
                                    workload_ref: 'workload',
                                 },
                              ],
                           },
                        },
                        secrets: {
                           'sec-01d6bkr38deswha5zrszemkm50:ver-01dvzmdb0pxdg9z1t60few7s70': {
                              secret_id: 'sec-01d6bkr38deswha5zrszemkm50',
                              secret_version: 'ver-01dvzmdb0pxdg9z1t60few7s70',
                              delegation_token: 'xTJ6-Mg-ZaxOCU-3X0FnMVsQEO_BKvFrJVW6cMPxHAA.1.b5f441e03a5c2095',
                           },
                           'sec-01dec420c9rpdgdc9p3astjs0x:ver-01e98vbvt1c0gs9tzpfprsavab': {
                              secret_id: 'sec-01dec420c9rpdgdc9p3astjs0x',
                              secret_version: 'ver-01e98vbvt1c0gs9tzpfprsavab',
                              delegation_token: 'uKz_hupF2GikdTKPIJXUudWWUJnMpEU1q-IMr7YKoFo.1.2cd1af11b0df7b37',
                           },
                           'sec-01dec420c9rpdgdc9p3astjs0x:ver-01ekmg8e2ywkvbb4d821a5ah1j': {
                              secret_id: 'sec-01dec420c9rpdgdc9p3astjs0x',
                              secret_version: 'ver-01ekmg8e2ywkvbb4d821a5ah1j',
                              delegation_token: 'uKz_hupF2GikdTKPIJXUudWWUJnMpEU1q-IMr7YKoFo.1.2cd1af11b0df7b37',
                           },
                           // одинаковые секреты с некорректными алиасами
                           'sec-00000000000000000000000123:ver-00000000000000000000000123': {
                              secret_id: 'sec-01dec420c9rpdgdc9p3astjs0x',
                              secret_version: 'ver-01dec420crsmyvwtny588pcwxr',
                           },
                           'sec-00000000000000000000000234:ver-00000000000000000000000234': {
                              secret_id: 'sec-01dec420c9rpdgdc9p3astjs0x',
                              secret_version: 'ver-01dec420crsmyvwtny588pcwxr',
                           },
                        },
                     },
                  },
                  constraints: {
                     antiaffinity_constraints: [
                        {
                           key: 'rack',
                           max_pods: 1,
                        },
                     ],
                  },
               },
               per_cluster_settings: {
                  sas: {
                     pod_count: 1,
                     deployment_strategy: {
                        max_unavailable: 1,
                     },
                  },
               },
            },
            pod_agent_sandbox_info: {
               revision: 2051752541,
            },
            logbroker_tools_sandbox_info: {
               revision: 2035657882,
            },
         },
      },
      revision_info: {
         description: 'add DU without secrets',
      },
      infra_components: {},
   },
} as DeepPartial<TStage>) as any;

// noinspection DuplicatedCode,SpellCheckingInspection
export const stageHugeFormStage: TStage = ({
   labels: {
      deploy_engine: 'env_controller',
      notifications_last_timestamp: 1604582202623258000,
      separate_du_revision: 'true',
      stagectl_epoch: 381,
      stagectl_vcs: {
         svn_branch: 'stage_controller/stable-94-1',
         svn_revision: 7487082,
         svn_tag: 'stage_controller/stable-94-1',
      },
   },
   spec: {
      account_id: 'abc:service:3494',
      revision: 2,
      deploy_units: {
         deployUnit: {
            network_defaults: {
               network_id: '_SEARCHSAND_',
            },
            endpoint_sets: [
               {
                  port: 80,
               },
            ],
            revision: 1,
            replica_set: {
               replica_set_template: {
                  pod_template_spec: {
                     spec: {
                        resource_requests: {
                           vcpu_guarantee: 100,
                           vcpu_limit: 100,
                           memory_guarantee: 1073741824,
                           memory_limit: 1073741824,
                        },
                        disk_volume_requests: [
                           {
                              id: 'disk-0',
                              labels: {
                                 used_by_infra: true,
                              },
                              storage_class: 'hdd',
                              quota_policy: {
                                 capacity: 3221225472,
                                 bandwidth_guarantee: 31457280,
                                 bandwidth_limit: 62914560,
                              },
                           },
                        ],
                        pod_agent_payload: {
                           spec: {
                              resources: {
                                 layers: [
                                    {
                                       id: 'layer',
                                       checksum: 'EMPTY:',
                                       url: 'sbr:2061235470',
                                    },
                                    {
                                       id: 'simple_http_server',
                                       checksum: 'EMPTY:',
                                       url: 'sbr:755375039',
                                    },
                                 ],
                              },
                              workloads: [
                                 {
                                    id: 'workload',
                                    readiness_check: {
                                       tcp_check: {
                                          port: 80,
                                       },
                                    },
                                    box_ref: 'box',
                                    start: {
                                       command_line: "/simple_http_server 80 'Hello my dear @khoden!'",
                                    },
                                    transmit_logs: true,
                                 },
                              ],
                              boxes: [
                                 {
                                    id: 'box',
                                    rootfs: {
                                       layer_refs: ['layer', 'simple_http_server'],
                                    },
                                 },
                              ],
                              mutable_workloads: [
                                 {
                                    workload_ref: 'workload',
                                 },
                              ],
                           },
                        },
                     },
                  },
                  constraints: {
                     antiaffinity_constraints: [
                        {
                           key: 'rack',
                           max_pods: 1,
                        },
                     ],
                  },
               },
               per_cluster_settings: {
                  sas: {
                     pod_count: 1,
                     deployment_strategy: {
                        max_unavailable: 1,
                     },
                  },
               },
            },
            pod_agent_sandbox_info: {
               revision: 1776921168,
            },
         },
         DeployUnit1: {
            network_defaults: {
               network_id: '_SEARCHSAND_',
            },
            tvm_config: {},
            endpoint_sets: [
               {
                  port: 80,
               },
            ],
            revision: 2,
            replica_set: {
               replica_set_template: {
                  pod_template_spec: {
                     spec: {
                        resource_requests: {
                           vcpu_guarantee: 100,
                           vcpu_limit: 100,
                           memory_guarantee: 1073741824,
                           memory_limit: 1073741824,
                        },
                        ip6_address_requests: [
                           {
                              network_id: '_SEARCHSAND_',
                              vlan_id: 'backbone',
                              enable_dns: true,
                           },
                           {
                              network_id: '_SEARCHSAND_',
                              vlan_id: 'fastbone',
                              enable_dns: true,
                           },
                        ],
                        disk_volume_requests: [
                           {
                              id: 'khoden-test-create-stage-disk-0',
                              labels: {
                                 used_by_infra: true,
                              },
                              storage_class: 'hdd',
                              quota_policy: {
                                 capacity: 3221225472,
                              },
                           },
                        ],
                        pod_agent_payload: {
                           spec: {
                              resources: {
                                 layers: [
                                    {
                                       id: 'base-layer-0',
                                       checksum: 'EMPTY:',
                                       url: 'sbr:2061235470',
                                    },
                                    {
                                       id: 'simple_http_server',
                                       checksum: 'EMPTY:',
                                       url: 'sbr:755375039',
                                    },
                                 ],
                              },
                              workloads: [
                                 {
                                    id: 'Box1-Workload1',
                                    env: [
                                       {
                                          name: 'mySuperVariable',
                                          value: {
                                             literal_env: {
                                                value: 'mySuperValue',
                                             },
                                          },
                                       },
                                    ],
                                    readiness_check: {
                                       tcp_check: {
                                          port: 80,
                                       },
                                    },
                                    box_ref: 'Box1',
                                    start: {
                                       command_line: "/simple_http_server 80 'Hello my dear @khoden!'",
                                    },
                                    transmit_logs: true,
                                 },
                              ],
                              boxes: [
                                 {
                                    id: 'Box1',
                                    rootfs: {
                                       layer_refs: ['base-layer-0', 'simple_http_server'],
                                    },
                                 },
                              ],
                              mutable_workloads: [
                                 {
                                    workload_ref: 'Box1-Workload1',
                                 },
                              ],
                           },
                        },
                        host_infra: {
                           monitoring: {},
                        },
                     },
                  },
                  constraints: {
                     antiaffinity_constraints: [
                        {
                           key: 'rack',
                           max_pods: 1,
                        },
                     ],
                  },
               },
               per_cluster_settings: {
                  sas: {
                     pod_count: 1,
                     deployment_strategy: {
                        max_unavailable: 1,
                     },
                  },
               },
            },
            pod_agent_sandbox_info: {
               revision: 1776921168,
            },
         },
      },
      revision_info: {},
   },
   meta: {
      inherit_acl: true,
      type: 'stage',
      project_id: 'khoden-deploy-ui',
      id: 'khoden-test-create-stage',
      creation_time: 1600937279013405,
      account_id: 'abc:service:3494',
      acl: [
         {
            action: 'allow',
            permissions: ['read', 'write', 'create', 'ssh_access', 'root_ssh_access', 'read_secrets'],
            subjects: ['robot-drug-deploy'],
         },
         {
            action: 'allow',
            permissions: ['read', 'write', 'create', 'use'],
            subjects: ['deploy:khoden-deploy-ui.OWNER'],
            attributes: ['', '/spec', '/labels', '/annotations'],
         },
         {
            action: 'allow',
            permissions: ['ssh_access', 'root_ssh_access'],
            subjects: ['deploy:khoden-deploy-ui.OWNER'],
            attributes: ['/access/deploy/box/default'],
         },
         {
            action: 'allow',
            permissions: ['read', 'write', 'create'],
            subjects: ['deploy:khoden-deploy-ui.MAINTAINER'],
            attributes: ['', '/spec', '/labels', '/annotations', '/meta/project_id'],
         },
         {
            action: 'allow',
            permissions: ['ssh_access', 'root_ssh_access'],
            subjects: ['deploy:khoden-deploy-ui.MAINTAINER'],
            attributes: ['/access/deploy/box/default'],
         },
      ],
      uuid: '67de97b4-67e0f2b3-b1c1cd80-8d04cff2',
   },
} as DeepPartial<TStage>) as any;

export const stageWithDynamicResources: TStage = ({
   meta: {
      fqid: 'yp|xdc|stage|RULES|ce42dd5e-2864db46-81317ace-2f0a38a4',
      inherit_acl: true,
      type: 'stage',
      project_id: 'nodejsgirl',
      id: 'RULES',
      creation_time: 1619788194176296,
      account_id: 'abc:service:3494',
      acl: [
         {
            action: 'allow',
            permissions: ['read', 'read_secrets', 'write', 'create', 'ssh_access', 'root_ssh_access'],
            subjects: ['robot-drug-deploy'],
         },
         {
            action: 'allow',
            permissions: ['use'],
            subjects: ['deploy:nodejsgirl.RULES.APPROVER'],
            attributes: ['/access/deploy/approvers'],
         },
         {
            action: 'allow',
            permissions: ['write'],
            subjects: ['deploy:nodejsgirl.RULES.APPROVER'],
            attributes: ['/control/approve', '/control/disapprove'],
         },
      ],
      uuid: 'ce42dd5e-2864db46-81317ace-2f0a38a4',
   },
   labels: {
      deploy_engine: 'env_controller',
      notifications_last_timestamp: 1620997391187356000,
   },
   spec: {
      account_id: 'abc:service:3494',
      revision: 4,
      deploy_units: {
         deployUnit: {
            network_defaults: {
               network_id: '_YA_DEPLOY_NETS_',
            },
            endpoint_sets: [
               {
                  port: 80,
               },
            ],
            revision: 3,
            replica_set: {
               replica_set_template: {
                  pod_template_spec: {
                     spec: {
                        resource_requests: {
                           vcpu_guarantee: 100,
                           vcpu_limit: 100,
                           memory_guarantee: 1073741824,
                           memory_limit: 1073741824,
                        },
                        disk_volume_requests: [
                           {
                              id: 'disk-0',
                              labels: {
                                 used_by_infra: true,
                              },
                              storage_class: 'hdd',
                              quota_policy: {
                                 capacity: 3221225472,
                                 bandwidth_guarantee: 15728640,
                                 bandwidth_limit: 31457280,
                              },
                           },
                        ],
                        pod_agent_payload: {
                           spec: {
                              resources: {
                                 layers: [
                                    {
                                       id: 'layer',
                                       checksum: 'EMPTY:',
                                       url: 'rbtorrent:49969bbdbc58134227a8e3276e92d843f0f904b2',
                                    },
                                    {
                                       id: 'simple_http_server_layer',
                                       checksum: 'EMPTY:',
                                       url: 'sbr:755375039',
                                    },
                                 ],
                                 static_resources: [
                                    {
                                       id: 'StaticResourceID',
                                       verification: {
                                          checksum: 'EMPTY:',
                                          check_period_ms: 180000,
                                       },
                                       url: 'sbr:755375039',
                                    },
                                 ],
                              },
                              workloads: [
                                 {
                                    id: 'workload',
                                    readiness_check: {
                                       tcp_check: {
                                          port: 80,
                                       },
                                    },
                                    box_ref: 'box',
                                    start: {
                                       command_line: "/simple_http_server 80 'Hello my dear @nodejsgirl!'",
                                    },
                                    transmit_logs: true,
                                 },
                              ],
                              boxes: [
                                 {
                                    id: 'box',
                                    rootfs: {
                                       layer_refs: ['layer', 'simple_http_server_layer'],
                                    },
                                    static_resources: [
                                       {
                                          resource_ref: 'StaticResourceID',
                                          mount_point: 'static_resource/',
                                       },
                                    ],
                                 },
                              ],
                              mutable_workloads: [
                                 {
                                    workload_ref: 'workload',
                                 },
                              ],
                           },
                        },
                     },
                  },
                  constraints: {
                     antiaffinity_constraints: [
                        {
                           key: 'rack',
                           max_pods: 1,
                        },
                     ],
                  },
               },
               per_cluster_settings: {
                  sas: {
                     pod_count: 1,
                     deployment_strategy: {
                        max_unavailable: 1,
                     },
                  },
               },
            },
            enable_dynamic_resource_updater: true,
         },
      },
      dynamic_resources: {
         DynamicResourceID: {
            deploy_unit_ref: 'deployUnit',
            dynamic_resource: {
               revision: 1,
               update_window: 1,
               deploy_groups: [
                  {
                     mark: 'all',
                     urls: ['sbr:755375039'],
                     storage_options: {
                        box_ref: 'box',
                        destination: 'Destination',
                        storage_dir: 'Storage',
                        cached_revisions_count: 2,
                     },
                  },
               ],
            },
         },
      },
   },
} as DeepPartial<TStage>) as any;
