interface ClusterConfig {
   title: string;
   value: string;
}

interface ServiceEndpoint {
   name: string;
   endpoint: string;
}

interface AppConfig {
   authorizePath: string;
   avatarHost: string;
   blackboxHost: string;
   clusters: ClusterConfig[];
   lostClusters: string[];
   overrideGeoLocation: Record<string, string>;
   deployEngine: string;
   deployRobots: string[];
   envName: string;
   feedbackFormId: number | null;
   nannyUiDomain: string;
   passportHost: string;
   resignPath: string;
   idmSystemName: string;
   serviceWorkerRefreshIntervalMinutes: number;
   services: ServiceEndpoint[];
   yasmPush: string;
   clck: string;
}

interface AppUser {
   uid: string;
   login: string;
}

interface AppEnvVariables {
   NODE_ENV: 'production' | 'development' | 'test';
   PUBLIC_URL: string;

   /**
    * ID счетчика метрики
    */
   REACT_APP_METRIKA: number | undefined;

   /**
    * Дата сборки или старта dev-server
    */
   REACT_APP_NOW: string;

   /**
    * Версия из package.json
    */
   REACT_APP_VERSION: string;
}

interface Window {
   /**
    * Лучше не использовать напрямую из window, есть обёртка Config.
    *
    * Конфиг можно получить из контекста ConfigContext или хука useConfig()
    */
   CONFIG: AppConfig;

   USER: AppUser;

   REACT_APP_METRIKA: string;

   /**
    * Сервис TestActions, используемый только напрямую из E2E тестов
    */
   testActions: any;

   getUsedYpPaths: () => any;
}
