declare module 'react-diff-view' {
   interface ChangeItem {
      content: string;
      isNormal: boolean;
      newLineNumber: number;
      oldLineNumber: number;
      type: 'normal';
   }

   export interface HunkModel {
      content: string;
      changes: ChangeItem[];
   }

   export interface Token {
      a: unknown;
   }

   interface ParseResult {
      hunks: HunkModel[];
      type: unknown;
   }

   interface ParseDiffOptions {
      nearbySequences: 'zip';
   }

   export function parseDiff(diff: string, options?: Partial<ParseDiffOptions>): ParseResult[];

   interface TokenizeOptions {
      enhancers: unknown[];
      highlight: boolean;
      language: string;
      oldSource: string;
      refractor: any;
   }

   export function tokenize(hunks: HunkModel[], options?: Partial<TokenizeOptions>): Token[];

   export type DiffViewType = 'split' | 'unified';

   interface DiffProps {
      children: (hunks: HunkModel[]) => React.ReactNode;
      className?: string;
      diffType: unknown;
      gutterType: 'default' | 'none' | 'anchor';
      hunks: HunkModel[];
      tokens: Token[];
      viewType: DiffViewType;
   }

   export const Diff: React.ComponentType<DiffProps>;

   interface HunkProps {
      hunk: HunkModel;
   }

   export const Hunk: React.ComponentType<HunkProps>;
}
