declare module 'unidiff' {
   interface DiffResult {
      count: number;
      type: 's' | '+' | '-';
      value: string;
      added?: boolean;
      removed?: boolean;
   }

   interface FormatLineOptions {
      /**
       * file name for input a, defaults to 'a'
       */
      aname: string;

      /**
       * file name for input b, defaults to 'b'
       */
      bname: string;

      /**
       * default values for pre_context and post_context (specify both in one setting)
       * (context defaults to 3 when nothing is specified)
       */
      context: number;

      /**
       * format of output text.  currently only "unified" is supported
       */
      format: 'unified';

      /**
       * write up to this many unmodified lines after each change
       */
      post_context: number;

      /**
       * write up to this many unmodified lines before each change
       */
      pre_context: number;
   }

   export function diffLines(a: string, b: string): DiffResult[];

   export function formatLines(r: DiffResult[], options?: Partial<FormatLineOptions>): string;
}
