import { getPaths, pathBuilder } from './buildPath';

describe('utils|buildPath', () => {
   it('simple path', () => {
      const path = pathBuilder({
         separators: { constLeft: '.', letLeft: '=' },
         hideSeparators: { firstConstLeft: true },
      });

      type SimpleObject = {
         a: {
            b: Record<string, number>;
         };
      };
      const model = getPaths<SimpleObject>();

      expect(path(model.a.b('c'))).toBe('a.b=c');
      expect(path(model.a.b('c')(1))).toBe('a.b=c=1');
   });

   it('form path', () => {
      const path = pathBuilder({
         separators: { constLeft: '.', letLeft: '[', letRight: ']' },
         hideSeparators: { firstConstLeft: true },
      });

      type FormValues = {
         stage: {
            deployUnits: Array<{
               id: string;
               resources: Record<'cpu' | 'mem' | 'disk', { capacity: number }>;
            }>;
         };
      };
      const model = getPaths<FormValues>();

      expect(path(model.stage.deployUnits(0).resources.cpu.capacity)).toBe(
         'stage.deployUnits[0].resources.cpu.capacity',
      );
   });
});
