import { createE2eSelector } from './createE2eSelector';

describe('utils|formatters/createE2eSelector', () => {
   it('use explicit value', () => {
      expect(createE2eSelector('x xx', 'yyy', 'zz')).toBe('x xx');
   });

   it('use fallback', () => {
      expect(createE2eSelector('', 'Yyy', 'zz')).toBe('Yyy');
      expect(createE2eSelector(null, 'Yyy', 'zz')).toBe('Yyy');
      expect(createE2eSelector(undefined, 'Yyy', 'zz')).toBe('Yyy');
   });

   it('convert fallback to PascalCase', () => {
      expect(createE2eSelector('', 'i am a button', 'zz')).toBe('IAmAButton');
   });

   it('skip empty fallback variant', () => {
      expect(createE2eSelector('', '', 'i am a button', 'zz')).toBe('IAmAButton');
      expect(createE2eSelector('', null, 'i am a button', 'zz')).toBe('IAmAButton');
      expect(createE2eSelector('', undefined, 'i am a button', 'zz')).toBe('IAmAButton');
   });

   it('use default value', () => {
      expect(createE2eSelector(null, '', undefined)).toBe('NoE2eSelector');
   });
});
