import { capitalize } from '@yandex-infracloud-ui/libs';

type Variant = string | null | undefined;

export function createE2eSelector(explicitSelector: Variant, ...fallback: Variant[]) {
   if (explicitSelector) {
      return explicitSelector;
   }

   for (const variant of fallback) {
      if (variant) {
         return toPascalCase(variant);
      }
   }

   return 'NoE2eSelector';
}

function toPascalCase(v: string) {
   return v
      .split(/[-./\\()"',;<>~!@#$%^&*|+=[\]{}`~?:\s_]/u)
      .filter(Boolean)
      .map(capitalize)
      .join('');
}
