import { humanizeYupErrors } from './humanizeYupErrors';

describe('utils/formatters|humanizeYupErrors', () => {
   it('should return unchanged for primitives', () => {
      expect(humanizeYupErrors(1)).toBe(1);
      expect(humanizeYupErrors(null)).toBe(null);
      expect(humanizeYupErrors(undefined)).toBe(undefined);
      expect(humanizeYupErrors(/xx/)).toEqual(/xx/);
   });

   it('should clean undefined from arrays', () => {
      expect(humanizeYupErrors([undefined, undefined, { x: 'y' }])).toEqual([{ x: 'y' }]);
      expect(humanizeYupErrors({ errors: [undefined, undefined, { x: 'y' }] })).toEqual({ errors: [{ x: 'y' }] });
   });
});
