import { YtError } from '../../models';

export function decodeYPErrorMessage(msg: string) {
   const msgString = msg.replace(/\\\\x/g, '%').replace(/\\x/g, '%');
   try {
      return decodeURIComponent(msgString);
   } catch (e) {
      console.error(e);
      return msgString;
   }
}

export function decodeYPErrorMessages(ypError: YtError) {
   if (!ypError) {
      return ypError;
   }

   const newError = { ...ypError };
   if (newError.message) {
      newError.message = decodeYPErrorMessage(newError.message);
   }

   if (!newError.inner_errors) {
      return newError;
   }

   newError.inner_errors = newError.inner_errors.map(error => decodeYPErrorMessages(error));
   return newError;
}
