import { Dictionary } from '@reduxjs/toolkit';

export function createDictionary<T>(items: T[], keyExtractor: (item: NonNullable<T>) => string): Dictionary<T> {
   return items.reduce(createDictionaryReducer(keyExtractor), {} as Dictionary<T>);
}

export function createDictionaryReducer<T>(keyExtractor: (item: NonNullable<T>) => string) {
   return (acc: Dictionary<T>, item: T) => {
      if (item) {
         acc[keyExtractor(item!)] = item;
      }

      return acc;
   };
}
