export function customMap<T extends string, V, R>(object: Map<T, V>, map: (value: V, id?: T) => R): Map<T, R> {
   return new Map(Array.from(object.entries()).map(([id, value]) => [id, map(value, id)]));
}
