export const metaSymbol = Symbol('meta');

/**
 * обновляет часть объекта по пути из строк и символов, перезаписывает примитивы
 * @param object обновляемый объект
 * @param chain массив из свойств, формирует путь для обновления, может включать символы
 * @param value значение, которое необходимо вставить
 */
export function deepUpdateObject(object: Record<string, any>, chain: Array<string | symbol>, value: any) {
   if (chain.length === 0) {
      return value;
   }
   const root = object;
   let current: any = root;
   let previous: any = current;
   for (let i = 0; i < chain.length; i += 1) {
      const field = chain[i];
      if (i === chain.length - 1) {
         if (typeof current === 'object' && current !== null) {
            current[field] = value;
         } else {
            // запись мета данных для примитивов
            if (!(metaSymbol in previous)) {
               previous[metaSymbol] = {};
            }
            if (!(chain[i - 1] in previous[metaSymbol])) {
               previous[metaSymbol][chain[i - 1]] = {};
            }
            previous[metaSymbol][chain[i - 1]][field] = value;
         }
      } else {
         previous = current;
         if (!(field in current)) {
            current[field] = {};
         }
         current = current[field];
      }
   }
   return root;
}

// TODO: проверить

/**
 * Проверяет содержится ли цепочка свойств в объекте, включая символьные свойства
 * @param object проверяемый объект
 * @param chain цепочка свойств
 */
export function hasObjectChain(object: any, chain: (string | symbol)[]): boolean {
   if (typeof object !== 'object' || object === null) {
      // пропускаем примитивы
      return false;
   }
   if (chain.length === 0) {
      // нет цепочки, значит мы в корне объекта, он существует
      return true;
   }
   const head = chain[0];

   if (head in object) {
      const child = object[head];
      const tail = chain.slice(1);

      // функции пропускаем как конечные объекты
      if (typeof child === 'object' && child !== null) {
         return hasObjectChain(child, tail);
      }

      // примитив или функция
      if (tail.length > 0) {
         // цепочка больше, чем вложенность объекта
         return false;
      }

      // дошли до листьев дерева
      return true;
   }

   return false;
}
