import { getListItem } from './getListItem';

describe('utils|helpers/getListItem', () => {
   it('should return item by positive index', () => {
      expect(getListItem([1, 2, 3, 4], 2)).toBe(3);
      expect(getListItem([1, 2, 3, 4], 10)).toBeUndefined();
   });

   it('should return first item', () => {
      expect(getListItem([1, 2, 3, 4], 'first')).toBe(1);
      expect(getListItem([], 'first')).toBeUndefined();
   });

   it('should return last item', () => {
      expect(getListItem([1, 2, 3, 4], 'last')).toBe(4);
      expect(getListItem([], 'last')).toBeUndefined();
   });

   it('should return penultimate item', () => {
      expect(getListItem([1, 2, 3, 4], 'penultimate')).toBe(3);
      expect(getListItem([1], 'penultimate')).toBeUndefined();
      expect(getListItem([], 'penultimate')).toBeUndefined();
   });

   it('should return item by negative index', () => {
      expect(getListItem([1, 2, 3, 4], -3)).toBe(2);
      expect(getListItem([1, 2, 3, 4], -10)).toBeUndefined();
   });
});
