type KnownIndex = 'first' | 'penultimate' | 'last';

const knownIndexes = new Map<KnownIndex, number>([
   ['first', 0],
   ['penultimate', -2],
   ['last', -1],
]);

export function getListItem<T>(list: T[], index: KnownIndex | number): T | undefined {
   const numberIndex = knownIndexes.has(index as KnownIndex)
      ? knownIndexes.get(index as KnownIndex)!
      : (index as number);

   // positive
   if (numberIndex >= 0) {
      return list[numberIndex];
   }

   return list[list.length + numberIndex];
}
