import { getSequentialId } from './getSequentialId';

describe('utils|getSequentialId', () => {
   it('should return newId if it is uniq', () => {
      expect(getSequentialId('workload', [])).toBe('workload');
      expect(getSequentialId('workload', ['empty_workload', 'haproxy_workload'])).toBe('workload');
   });

   it('should return newId with number if it is not uniq', () => {
      expect(getSequentialId('workload', ['workload'])).toBe('workload_1');
   });

   it('should return newId with number if it is not uniq 2', () => {
      expect(getSequentialId('workload', ['workload', 'workload_1', 'workload_2'])).toBe('workload_3');
   });

   it('should return newId with number if it is not uniq 3', () => {
      expect(getSequentialId('workload', ['workload', 'workload_1', 'workload_3'])).toBe('workload_4');
   });

   it('should return newId with number if it is not uniq', () => {
      expect(getSequentialId('workload', ['workload', 'box_1', 'box_2'])).toBe('workload_1');
   });

   it('should handle options.separator', () => {
      expect(getSequentialId('workload', ['workload', 'box_1', 'box_2'], { separator: '#' })).toBe('workload#1');
   });

   it('should add suffix', () => {
      expect(getSequentialId('workload', ['workload', 'workload_clone', 'workload_clone_1'], { suffix: 'clone' })).toBe(
         'workload_clone_2',
      );
   });

   it('should add suffix without number in first time', () => {
      expect(getSequentialId('workload', ['workload'], { suffix: 'clone' })).toBe('workload_clone');
      expect(getSequentialId('workload', ['workload', 'workload_clone'], { suffix: 'clone' })).toBe('workload_clone_1');
   });

   it('should ignore suffix, if added', () => {
      expect(
         getSequentialId('workload_clone_1', ['workload', 'workload_clone', 'workload_clone_1'], { suffix: 'clone' }),
      ).toBe('workload_clone_2');
   });
});
