const defaultOptions = {
   separator: '_',
   suffix: '',
};

type GetSequentialIdOptions = Partial<typeof defaultOptions>;

export function getSequentialId(newId: string, siblings: string[], options?: GetSequentialIdOptions): string {
   const actualOptions = { ...defaultOptions, ...options };

   const exist = siblings.includes(newId);

   if (!exist) {
      return newId;
   }

   const suffix = actualOptions.suffix ? actualOptions.separator + actualOptions.suffix : '';

   // ignore suffix
   if (actualOptions.suffix) {
      newId = newId
         .replace(new RegExp(`${suffix}$`), '')
         .replace(new RegExp(`${suffix}${actualOptions.separator}(\\d+)$`), '');
   }

   const re = new RegExp(`${newId}${suffix}${actualOptions.separator}(\\d+)$`);
   const maxId = siblings.reduce((acc, item) => {
      const m = item.match(re);
      if (m !== null) {
         const id = parseInt(m[1], 10);

         return id > acc ? id : acc;
      }

      return acc;
   }, 0);

   const idWithSuffix = `${newId}${suffix}`;
   const existSuffixed = siblings.includes(idWithSuffix);
   if (actualOptions.suffix && maxId === 0 && !existSuffixed) {
      return idWithSuffix;
   }

   return `${newId}${suffix}${actualOptions.separator}${maxId + 1}`;
}
