import yaml from 'js-yaml';

export function getValueFromYaml<T>(yamlText: string): { value: T | null; error: string | null } {
   let value: T | null = null;
   let error: string | null = null;
   try {
      value = yaml.load(yamlText) as T;
   } catch (e) {
      console.error(e);
      error = String(e);
   }

   return { value, error };
}
